/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;

public class DistributedCounters
extends AbstractDistributedRule {
    private static volatile Map<Serializable, AtomicInteger> counters;
    private final List<Serializable> idsToInitInBefore = new ArrayList<Serializable>();
    private final Map<Integer, Map<Serializable, AtomicInteger>> beforeBounceCounters = new HashMap<Integer, Map<Serializable, AtomicInteger>>();

    public static Builder builder() {
        return new Builder();
    }

    public DistributedCounters() {
        this(new Builder());
    }

    private DistributedCounters(Builder builder) {
        this.idsToInitInBefore.addAll(builder.ids);
    }

    @Override
    protected void before() {
        this.invoker().invokeInEveryVMAndController(() -> {
            counters = new ConcurrentHashMap<Serializable, AtomicInteger>();
        });
        for (Serializable id : this.idsToInitInBefore) {
            this.invoker().invokeInEveryVMAndController(() -> this.initialize(id));
        }
    }

    @Override
    protected void after() {
        this.invoker().invokeInEveryVMAndController(() -> {
            counters = null;
        });
    }

    @Override
    protected void afterCreateVM(VM vm) {
        vm.invoke(() -> {
            counters = new ConcurrentHashMap<Serializable, AtomicInteger>();
            return counters;
        });
        for (Serializable id : this.idsToInitInBefore) {
            vm.invoke(() -> this.initialize(id));
        }
        for (Serializable id : counters.keySet()) {
            vm.invoke(() -> counters.putIfAbsent(id, new AtomicInteger()));
        }
    }

    @Override
    protected void beforeBounceVM(VM vm) {
        this.beforeBounceCounters.put(vm.getId(), (Map)vm.invoke(() -> counters));
    }

    @Override
    protected void afterBounceVM(VM vm) {
        vm.invoke(() -> {
            counters = new ConcurrentHashMap<Serializable, AtomicInteger>();
            return counters;
        });
        Map<Serializable, AtomicInteger> beforeBounceCountersForVM = this.beforeBounceCounters.remove(vm.getId());
        for (Serializable id : beforeBounceCountersForVM.keySet()) {
            vm.invoke(() -> counters.putIfAbsent(id, (AtomicInteger)beforeBounceCountersForVM.get(id)));
        }
        for (Serializable id : this.idsToInitInBefore) {
            vm.invoke(() -> counters.putIfAbsent(id, new AtomicInteger()));
        }
        for (Serializable id : counters.keySet()) {
            vm.invoke(() -> counters.putIfAbsent(id, new AtomicInteger()));
        }
    }

    public DistributedCounters initialize(Serializable id) {
        this.invoker().invokeInEveryVMAndController(() -> counters.putIfAbsent(id, new AtomicInteger()));
        return this;
    }

    public AtomicInteger reference(Serializable id) {
        return counters.get(id);
    }

    public DistributedCounters increment(Serializable id) {
        counters.get(id).incrementAndGet();
        return this;
    }

    public DistributedCounters increment(Serializable id, int delta) {
        counters.get(id).addAndGet(delta);
        return this;
    }

    public DistributedCounters decrement(Serializable id) {
        counters.get(id).decrementAndGet();
        return this;
    }

    public DistributedCounters decrement(Serializable id, int delta) {
        counters.get(id).addAndGet(-delta);
        return this;
    }

    public int getTotal(Serializable id) {
        int total = counters.get(id).get();
        for (VM vm : VM.getAllVMs()) {
            total += ((Integer)vm.invoke(() -> counters.get(id).get())).intValue();
        }
        return total;
    }

    public int getLocal(Serializable id) {
        return counters.get(id).get();
    }

    public static class Builder {
        private final List<Serializable> ids = new ArrayList<Serializable>();

        public Builder withId(Serializable id) {
            this.ids.add(id);
            return this;
        }

        public DistributedCounters build() {
            return new DistributedCounters(this);
        }
    }
}

