/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.dunit.AsyncInvocation;
import org.apache.geode.test.dunit.DUnitEnv;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.RMIException;
import org.apache.geode.test.dunit.SerializableCallableIF;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.VMEventListener;
import org.apache.geode.test.dunit.internal.AsyncThreadId;
import org.apache.geode.test.dunit.internal.ChildVMLauncher;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.internal.IdentifiableCallable;
import org.apache.geode.test.dunit.internal.IdentifiableRunnable;
import org.apache.geode.test.dunit.internal.MethodInvokerResult;
import org.apache.geode.test.dunit.internal.ProcessHolder;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.internal.VMEventNotifier;
import org.apache.geode.test.version.VersionManager;
import org.apache.geode.test.version.VmConfiguration;
import org.apache.logging.log4j.Logger;

public class VM
implements Serializable {
    private static final Logger logger = LogService.getLogger();
    public static final int CONTROLLER_VM = -1;
    public static final int DEFAULT_VM_COUNT = DUnitLauncher.NUM_VMS;
    private static final Object[] EMPTY = new Object[0];
    private final Host host;
    private final int id;
    private VmConfiguration configuration;
    private RemoteDUnitVMIF client;
    private volatile boolean available;
    private volatile transient ProcessHolder processHolder;
    private final transient ChildVMLauncher childVMLauncher;

    public static int getVMId() {
        return DUnitEnv.get().getId();
    }

    @Deprecated
    public static int getCurrentVMNum() {
        return DUnitEnv.get().getId();
    }

    public static boolean isControllerVM() {
        return VM.getCurrentVMNum() == -1;
    }

    public static boolean isVM() {
        return VM.getCurrentVMNum() != -1;
    }

    public static VM getVM(int whichVM) {
        return Host.getHost(0).getVM(whichVM);
    }

    public static VM getVM(String geodeVersion, int whichVM) {
        return VM.getVM(VmConfiguration.forGeodeVersion((String)geodeVersion), whichVM);
    }

    public static VM getVM(VmConfiguration configuration, int whichVM) {
        return Host.getHost(0).getVM(configuration, whichVM);
    }

    public static List<VM> getAllVMs() {
        return Host.getHost(0).getAllVMs();
    }

    public static int getVMCount() {
        return Host.getHost(0).getVMCount();
    }

    public static VM getLocator() {
        return Host.getLocator();
    }

    public static VM getController() {
        return VM.getVM(-1);
    }

    public static String getHostName() {
        return Host.getHost(0).getHostName();
    }

    public static String getVMName(String version, int pid) {
        if (pid == -2) {
            return "locator";
        }
        if (pid < 0 || VersionManager.isCurrentVersion((String)version)) {
            return "vm" + pid;
        }
        return "vm" + pid + "_v" + version;
    }

    public static VM[] toArray(VM ... vms) {
        return vms;
    }

    public static VM[] toArray(List<VM> vmList) {
        return vmList.toArray(new VM[0]);
    }

    public static VM[] toArray(List<VM> vmList, VM ... vms) {
        return (VM[])ArrayUtils.addAll((Object[])vmList.toArray(new VM[0]), (Object[])vms);
    }

    public static VM[] toArray(VM[] vmArray, VM ... vms) {
        return (VM[])ArrayUtils.addAll((Object[])vmArray, (Object[])vms);
    }

    public static void addVMEventListener(VMEventListener listener) {
        VM.getVMEventNotifier().addVMEventListener(listener);
    }

    public static void removeVMEventListener(VMEventListener listener) {
        VM.getVMEventNotifier().removeVMEventListener(listener);
    }

    public static String dumpThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] allThreadIds = threadMXBean.getAllThreadIds();
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(allThreadIds, true, true);
        StringBuilder dumpWriter = new StringBuilder();
        Arrays.stream(threadInfos).filter(Objects::nonNull).forEach(dumpWriter::append);
        return dumpWriter.toString();
    }

    private static VMEventNotifier getVMEventNotifier() {
        return Host.getHost(0).getVMEventNotifier();
    }

    public VM(Host host, VmConfiguration configuration, int id, RemoteDUnitVMIF client, ProcessHolder processHolder, ChildVMLauncher childVMLauncher) {
        this.host = host;
        this.id = id;
        this.configuration = configuration;
        this.client = client;
        this.processHolder = processHolder;
        this.childVMLauncher = childVMLauncher;
        this.available = true;
    }

    public Host getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.configuration.geodeVersion().toString();
    }

    public VmConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getId() {
        return this.id;
    }

    public int getPid() {
        return (Integer)this.invoke(() -> ProcessUtils.identifyPid());
    }

    @Deprecated
    public <V> V invoke(Class<?> targetClass, String methodName) {
        this.checkAvailability(targetClass.getName(), methodName);
        return this.executeMethodOnClass(targetClass, methodName, new Object[0]);
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Class<?> targetClass, String methodName) {
        return this.invokeAsync(targetClass, methodName, null);
    }

    @Deprecated
    public <V> V invoke(Class<?> targetClass, String methodName, Object[] args) {
        this.checkAvailability(targetClass.getName(), methodName);
        return this.executeMethodOnClass(targetClass, methodName, args);
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Object targetObject, String methodName, Object[] args) {
        return AsyncInvocation.create(targetObject, methodName, () -> this.invoke(targetObject, methodName, args), this).start();
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Class<?> targetClass, String methodName, Object[] args) {
        return AsyncInvocation.create(targetClass, methodName, () -> this.invoke(targetClass, methodName, args), this).start();
    }

    public <V> AsyncInvocation<V> invokeAsync(SerializableRunnableIF runnable) {
        IdentifiableRunnable target = new IdentifiableRunnable(AsyncThreadId.nextId(), runnable);
        return AsyncInvocation.create(target, () -> this.invoke(target, target.getMethodName(), EMPTY), this).start();
    }

    public <V> AsyncInvocation<V> invokeAsync(String name, SerializableRunnableIF runnable) {
        IdentifiableRunnable target = new IdentifiableRunnable(AsyncThreadId.nextId(), name, runnable);
        return AsyncInvocation.create(target, () -> this.invoke(target, target.getMethodName(), EMPTY), this).start();
    }

    public <V> AsyncInvocation<V> invokeAsync(String name, SerializableCallableIF<V> callable) {
        IdentifiableCallable target = new IdentifiableCallable(AsyncThreadId.nextId(), name, callable);
        return AsyncInvocation.create(target, () -> this.invoke(target, target.getMethodName(), EMPTY), this).start();
    }

    public <V> AsyncInvocation<V> invokeAsync(SerializableCallableIF<V> callable) {
        IdentifiableCallable target = new IdentifiableCallable(AsyncThreadId.nextId(), callable);
        return AsyncInvocation.create(target, () -> this.invoke(target, target.getMethodName(), EMPTY), this).start();
    }

    public void invoke(String name, SerializableRunnableIF runnable) {
        this.checkAvailability(IdentifiableRunnable.class.getName(), "run");
        this.executeMethodOnObject(new IdentifiableRunnable(name, runnable), "run", new Object[0]);
    }

    public void invoke(SerializableRunnableIF runnable) {
        this.checkAvailability(runnable.getClass().getName(), "run");
        this.executeMethodOnObject(runnable, "run", new Object[0]);
    }

    public <V> V invoke(String name, SerializableCallableIF<V> callable) {
        this.checkAvailability(IdentifiableCallable.class.getName(), "call");
        return this.executeMethodOnObject(new IdentifiableCallable<V>(name, callable), "call", new Object[0]);
    }

    public <V> V invoke(SerializableCallableIF<V> callable) {
        this.checkAvailability(callable.getClass().getName(), "call");
        return this.executeMethodOnObject(callable, "call", new Object[0]);
    }

    @Deprecated
    public <V> V invoke(Object targetObject, String methodName) {
        this.checkAvailability(targetObject.getClass().getName(), methodName);
        return this.executeMethodOnObject(targetObject, methodName, new Object[0]);
    }

    @Deprecated
    public <V> V invoke(Object targetObject, String methodName, Object[] args) {
        this.checkAvailability(targetObject.getClass().getName(), methodName);
        return this.executeMethodOnObject(targetObject, methodName, args);
    }

    public synchronized void makeAvailable() {
        if (!this.available) {
            this.available = true;
            this.bounce();
        }
    }

    public VM bounce() {
        return this.bounce(this.configuration, false);
    }

    public VM bounceForcibly() {
        return this.bounce(this.configuration, true);
    }

    public VM bounce(String targetVersion) {
        return this.bounce(VmConfiguration.forGeodeVersion((String)targetVersion), false);
    }

    public synchronized VM bounce(VmConfiguration configuration, boolean force) {
        this.checkAvailability(this.getClass().getName(), "bounceVM");
        logger.info("Bouncing {} old pid is {} and configuration is {}", (Object)this.id, (Object)this.getPid(), (Object)configuration);
        VM.getVMEventNotifier().notifyBeforeBounceVM(this);
        this.available = false;
        try {
            if (force) {
                this.processHolder.killForcibly();
            } else {
                SerializableRunnableIF runnable = () -> new Thread(() -> {
                    try {
                        Thread.sleep(100L);
                        System.exit(0);
                    }
                    catch (InterruptedException e) {
                        logger.error("VM bounce thread interrupted before exiting.", (Throwable)e);
                    }
                }).start();
                this.executeMethodOnObject(runnable, "run", new Object[0]);
            }
            this.processHolder.waitFor();
            int remoteStubPort = AvailablePortHelper.getRandomAvailableTCPPort();
            this.processHolder = this.childVMLauncher.launchVM(configuration, this.id, true, remoteStubPort);
            this.configuration = configuration;
            this.client = this.childVMLauncher.getStub(this.id);
            this.available = true;
            logger.info("Bounced {}.  New pid is {} and configuration is {}", (Object)this.id, (Object)this.getPid(), (Object)configuration);
            VM.getVMEventNotifier().notifyAfterBounceVM(this);
        }
        catch (IOException | InterruptedException | NotBoundException e) {
            throw new Error("Unable to restart VM " + this.id, e);
        }
        return this;
    }

    private void checkAvailability(String className, String methodName) {
        if (!this.available) {
            throw new RMIException(this, className, methodName, new IllegalStateException("VM not available: " + String.valueOf(this)));
        }
    }

    public File getWorkingDirectory() {
        return DUnitEnv.get().getWorkingDirectory(this.getVersion(), this.getId());
    }

    public String toString() {
        return String.format("VM %d, Host %s, Geode %s, Java %s", this.getId(), this.getHost(), this.configuration.geodeVersion(), this.configuration.javaVersion());
    }

    private <V> V executeMethodOnObject(Object targetObject, String methodName, Object[] args) {
        try {
            MethodInvokerResult result = this.client.executeMethodOnObject(targetObject, methodName, args);
            if (result.exceptionOccurred()) {
                throw new RMIException(this, targetObject.getClass().getName(), methodName, result.getException(), result.getStackTrace());
            }
            return (V)result.getResult();
        }
        catch (RemoteException exception) {
            throw new RMIException(this, targetObject.getClass().getName(), methodName, exception);
        }
    }

    private <V> V executeMethodOnClass(Class<?> targetClass, String methodName, Object[] args) {
        try {
            MethodInvokerResult result = this.client.executeMethodOnClass(targetClass.getName(), methodName, args);
            if (result.exceptionOccurred()) {
                throw new RMIException(this, targetClass.getName(), methodName, result.getException(), result.getStackTrace());
            }
            return (V)result.getResult();
        }
        catch (RemoteException exception) {
            throw new RMIException(this, targetClass.getName(), methodName, exception);
        }
    }
}

