/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqAttributesFactory;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqResults;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.membership.utils.AvailablePort;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.SecurityTestUtils;
import org.apache.geode.security.generator.AuthzCredentialGenerator;
import org.apache.geode.security.generator.CredentialGenerator;
import org.apache.geode.security.generator.DummyCredentialGenerator;
import org.apache.geode.security.generator.XmlAuthzCredentialGenerator;
import org.apache.geode.security.templates.UsernamePrincipal;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.WaitCriterion;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.geode.test.version.VersionManager;
import org.apache.geode.test.version.VmConfiguration;
import org.awaitility.core.ThrowingRunnable;

@Deprecated
public abstract class ClientAuthorizationTestCase
extends JUnit4DistributedTestCase {
    private static final int PAUSE = 5000;
    protected static VM server1 = null;
    protected static VM server2 = null;
    protected static VM client1 = null;
    protected static VM client2 = null;
    public final VmConfiguration clientVmConfiguration;
    protected static final String regionName = "AuthRegion";
    protected static final String SUBREGION_NAME = "AuthSubregion";
    private static final String[] serverIgnoredExceptions = new String[]{"Connection refused", AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), NotAuthorizedException.class.getName(), GemFireSecurityException.class.getName(), RegionDestroyedException.class.getName(), ClassNotFoundException.class.getName()};
    private static final String[] clientIgnoredExceptions = new String[]{AuthenticationFailedException.class.getName(), NotAuthorizedException.class.getName(), RegionDestroyedException.class.getName()};

    public ClientAuthorizationTestCase() {
        this(VmConfiguration.current());
    }

    protected ClientAuthorizationTestCase(VmConfiguration clientVmConfiguration) {
        this.clientVmConfiguration = clientVmConfiguration;
    }

    @Override
    public final void preSetUp() throws Exception {
    }

    @Override
    public final void postSetUp() throws Exception {
        this.preSetUpClientAuthorizationTestBase();
        this.setUpClientAuthorizationTestBase();
        this.postSetUpClientAuthorizationTestBase();
    }

    private void setUpClientAuthorizationTestBase() throws Exception {
        Host host = Host.getHost(0);
        server1 = host.getVM("10240.0.0", 0);
        server2 = host.getVM("10240.0.0", 1);
        server1.invoke(() -> {
            ServerConnection.allowInternalMessagesWithoutCredentials = false;
            return false;
        });
        server2.invoke(() -> {
            ServerConnection.allowInternalMessagesWithoutCredentials = false;
            return false;
        });
        client1 = host.getVM(this.clientVmConfiguration, 2);
        client2 = host.getVM(this.clientVmConfiguration, 3);
        this.setUpIgnoredExceptions();
    }

    private void setUpIgnoredExceptions() {
        HashSet<String> serverExceptions = new HashSet<String>();
        serverExceptions.addAll(Arrays.asList(this.serverIgnoredExceptions()));
        if (serverExceptions.isEmpty()) {
            serverExceptions.addAll(Arrays.asList(serverIgnoredExceptions));
        }
        String[] serverExceptionsArray = serverExceptions.toArray(new String[serverExceptions.size()]);
        server1.invoke(() -> SecurityTestUtils.registerExpectedExceptions(serverExceptionsArray));
        server2.invoke(() -> SecurityTestUtils.registerExpectedExceptions(serverExceptionsArray));
        HashSet<String> clientExceptions = new HashSet<String>();
        clientExceptions.addAll(Arrays.asList(this.clientIgnoredExceptions()));
        if (clientExceptions.isEmpty()) {
            clientExceptions.addAll(Arrays.asList(clientIgnoredExceptions));
        }
        String[] clientExceptionsArray = serverExceptions.toArray(new String[clientExceptions.size()]);
        client2.invoke(() -> SecurityTestUtils.registerExpectedExceptions(clientExceptionsArray));
        SecurityTestUtils.registerExpectedExceptions(clientExceptionsArray);
    }

    protected String[] serverIgnoredExceptions() {
        return new String[0];
    }

    protected String[] clientIgnoredExceptions() {
        return new String[0];
    }

    protected void preSetUpClientAuthorizationTestBase() throws Exception {
    }

    protected void postSetUpClientAuthorizationTestBase() throws Exception {
    }

    @Override
    public final void preTearDown() throws Exception {
        this.preTearDownClientAuthorizationTestBase();
        this.tearDownClientAuthorizationTestBase();
        this.postTearDownClientAuthorizationTestBase();
    }

    @Override
    public final void postTearDown() throws Exception {
    }

    private final void tearDownClientAuthorizationTestBase() throws Exception {
        server1.invoke(() -> {
            ServerConnection.allowInternalMessagesWithoutCredentials = true;
            return true;
        });
        server2.invoke(() -> {
            ServerConnection.allowInternalMessagesWithoutCredentials = true;
            return true;
        });
        client1.invoke(() -> SecurityTestUtils.closeCache());
        client2.invoke(() -> SecurityTestUtils.closeCache());
        server1.invoke(() -> SecurityTestUtils.closeCache());
        server2.invoke(() -> SecurityTestUtils.closeCache());
    }

    protected void preTearDownClientAuthorizationTestBase() throws Exception {
    }

    protected void postTearDownClientAuthorizationTestBase() throws Exception {
    }

    protected static Properties buildProperties(String authenticator, String accessor, boolean isAccessorPP, Properties extraAuthProps, Properties extraAuthzProps) {
        Properties authProps = new Properties();
        if (authenticator != null) {
            authProps.setProperty("security-client-authenticator", authenticator);
        }
        if (accessor != null) {
            if (isAccessorPP) {
                authProps.setProperty("security-client-accessor-pp", accessor);
            } else {
                authProps.setProperty("security-client-accessor", accessor);
            }
        }
        if (VersionManager.getInstance().getCurrentVersionOrdinal() >= 75) {
            authProps.put("serializable-object-filter", UsernamePrincipal.class.getName());
        }
        return SecurityTestUtils.concatProperties(new Properties[]{authProps, extraAuthProps, extraAuthzProps});
    }

    protected static Integer createCacheServer(Properties authProps, Properties javaProps) {
        return SecurityTestUtils.createCacheServer(authProps, javaProps, 0, true, 0);
    }

    protected static int createCacheServer(int serverPort, Properties authProps, Properties javaProps) {
        Properties jprops = javaProps;
        if (jprops == null) {
            jprops = new Properties();
        }
        jprops.put("serializable-object-filter", "org.apache.geode.security.templates.UsernamePrincipal");
        return SecurityTestUtils.createCacheServer(authProps, jprops, serverPort, true, 0);
    }

    protected static Region getRegion() {
        return SecurityTestUtils.getCache().getRegion(regionName);
    }

    protected static Region getSubregion() {
        return SecurityTestUtils.getCache().getRegion("AuthRegion/AuthSubregion");
    }

    private static Region createSubregion(Region region) {
        Region subregion = ClientAuthorizationTestCase.getSubregion();
        if (subregion == null) {
            subregion = region.createSubregion(SUBREGION_NAME, region.getAttributes());
        }
        return subregion;
    }

    protected static String indicesToString(int[] indices) {
        Object str = "";
        if (indices != null && indices.length > 0) {
            str = (String)str + indices[0];
            for (int index = 1; index < indices.length; ++index) {
                str = (String)str + ",";
                str = (String)str + indices[index];
            }
        }
        return str;
    }

    protected static void doOp(OperationContext.OperationCode op, int[] indices, int flagsI, int expectedResult) throws InterruptedException {
        boolean operationOmitted = false;
        final int flags = flagsI;
        Region region = ClientAuthorizationTestCase.getRegion();
        if ((flags & 0x400) > 0) {
            Assert.assertNotNull((Object)region);
            Region subregion = null;
            if ((flags & 0x800) > 0) {
                if ((flags & 4) > 0) {
                    GeodeAwaitility.await().until(() -> ClientAuthorizationTestCase.getSubregion() == null);
                    subregion = ClientAuthorizationTestCase.getSubregion();
                    Assert.assertNull((Object)subregion);
                    return;
                }
                GeodeAwaitility.await().until(() -> ClientAuthorizationTestCase.getSubregion() != null);
                subregion = ClientAuthorizationTestCase.getSubregion();
                Assert.assertNotNull((Object)subregion);
            } else {
                subregion = ClientAuthorizationTestCase.createSubregion(region);
            }
            Assert.assertNotNull((Object)subregion);
            region = subregion;
        } else {
            if ((flags & 4) > 0) {
                GeodeAwaitility.await().until(() -> ClientAuthorizationTestCase.getRegion() == null);
                region = ClientAuthorizationTestCase.getRegion();
                Assert.assertNull((Object)region);
                return;
            }
            Assert.assertNotNull((Object)region);
        }
        String[] keys = SecurityTestUtils.KEYS;
        String[] vals = (flags & 0x10) > 0 ? SecurityTestUtils.NVALUES : SecurityTestUtils.VALUES;
        InterestResultPolicy policy = InterestResultPolicy.KEYS_VALUES;
        if ((flags & 0x8000) > 0) {
            policy = InterestResultPolicy.NONE;
        }
        final int numOps = indices.length;
        System.out.println("Got doOp for op: " + op.toString() + ", numOps: " + numOps + ", indices: " + ClientAuthorizationTestCase.indicesToString(indices) + ", expect: " + expectedResult + " flags: " + OpFlags.description(flags));
        boolean exceptionOccurred = false;
        boolean breakLoop = false;
        for (int i : indices) {
            if (breakLoop) break;
            int index = i;
            try {
                final String key = keys[index];
                final String expectedVal = vals[index];
                if (op.isGet()) {
                    Object value = null;
                    if ((flags & 0x20) > 0) {
                        String searchKey;
                        breakLoop = true;
                        ArrayList<String> arrayList = new ArrayList<String>(numOps);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            searchKey = keys[keyNum];
                            arrayList.add(searchKey);
                            if ((flags & 0x200) > 0) {
                                AbstractRegionEntry entry = (AbstractRegionEntry)((LocalRegion)region).getRegionEntry((Object)searchKey);
                                System.out.println(keyNum + ": key is " + String.valueOf(searchKey) + " and entry is " + String.valueOf(entry));
                                Assert.assertFalse((boolean)region.containsKey((Object)searchKey));
                                continue;
                            }
                            if (keyNumIndex % 2 != 1) continue;
                            Assert.assertTrue((boolean)region.containsKey((Object)searchKey));
                            region.localInvalidate((Object)searchKey);
                        }
                        Map entries = region.getAll(arrayList);
                        for (int keyNum : indices) {
                            searchKey = keys[keyNum];
                            if ((flags & 1) > 0) {
                                Assert.assertFalse((boolean)entries.containsKey(searchKey));
                                continue;
                            }
                            Assert.assertTrue((boolean)entries.containsKey(searchKey));
                            value = entries.get(searchKey);
                            Assert.assertEquals((Object)vals[keyNum], (Object)value);
                        }
                        break;
                    }
                    if ((flags & 0x100) > 0) {
                        Callable<Boolean> callable = new Callable<Boolean>(){
                            private Region region;

                            @Override
                            public Boolean call() throws Exception {
                                Object value = SecurityTestUtils.getLocalValue(this.region, key);
                                return (flags & 1) > 0 != expectedVal.equals(value);
                            }

                            public Callable<Boolean> init(Region region) {
                                this.region = region;
                                return this;
                            }
                        }.init(region);
                        GeodeAwaitility.await().until(callable);
                        value = SecurityTestUtils.getLocalValue(region, key);
                    } else if ((flags & 0x10000) > 0) {
                        SecurityTestUtils.getCache().getCacheTransactionManager().begin();
                        Region.Entry entry = region.getEntry((Object)key);
                        ArrayList a = new ArrayList();
                        a.addAll(a);
                        region.getAll(a);
                        SecurityTestUtils.getCache().getCacheTransactionManager().commit();
                        value = entry.getValue();
                    } else {
                        if ((flags & 0x200) > 0) {
                            Assert.assertFalse((boolean)region.containsKey((Object)key));
                        } else {
                            Assert.assertTrue((region.containsKey((Object)key) || ((LocalRegion)region).getRegionEntry((Object)key).isTombstone() ? 1 : 0) != 0);
                            region.localInvalidate((Object)key);
                        }
                        value = region.get((Object)key);
                    }
                    if ((flags & 1) > 0) {
                        Assert.assertFalse((boolean)expectedVal.equals(value));
                    } else {
                        Assert.assertNotNull((Object)value);
                        Assert.assertEquals((Object)expectedVal, (Object)value);
                    }
                } else if (op.isPut()) {
                    region.put((Object)key, (Object)expectedVal);
                } else if (op.isPutAll()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int j : indices) {
                        map.put(keys[j], vals[j]);
                    }
                    region.putAll(map);
                    breakLoop = true;
                } else if (op.isDestroy()) {
                    if ((flags & 0x100) > 0) {
                        region.localDestroy((Object)key);
                    } else {
                        region.destroy((Object)key);
                    }
                } else if (op.isInvalidate()) {
                    if (region.containsKey((Object)key)) {
                        if ((flags & 0x100) > 0) {
                            region.localInvalidate((Object)key);
                        } else {
                            region.invalidate((Object)key);
                        }
                    }
                } else if (op.isContainsKey()) {
                    boolean result = (flags & 0x100) > 0 ? region.containsKey((Object)key) : region.containsKeyOnServer((Object)key);
                    if ((flags & 1) > 0) {
                        Assert.assertFalse((boolean)result);
                    } else {
                        Assert.assertTrue((boolean)result);
                    }
                } else if (op.isRegisterInterest()) {
                    if ((flags & 0x80) > 0) {
                        breakLoop = true;
                        ArrayList<String> keyList = new ArrayList<String>(numOps);
                        for (int keyNum : indices) {
                            keyList.add(keys[keyNum]);
                        }
                        region.registerInterest(keyList, policy);
                    } else if ((flags & 0x40) > 0) {
                        breakLoop = true;
                        region.registerInterestRegex("key[1-" + numOps + "]", policy);
                    } else if ((flags & 0x20) > 0) {
                        breakLoop = true;
                        region.registerInterest((Object)"ALL_KEYS", policy);
                    } else {
                        region.registerInterest((Object)key, policy);
                    }
                } else if (op.isUnregisterInterest()) {
                    if ((flags & 0x80) > 0) {
                        breakLoop = true;
                        ArrayList<String> keyList = new ArrayList<String>(numOps);
                        for (int keyNum : indices) {
                            keyList.add(keys[keyNum]);
                        }
                        region.unregisterInterest(keyList);
                    } else if ((flags & 0x40) > 0) {
                        breakLoop = true;
                        region.unregisterInterestRegex("key[1-" + numOps + "]");
                    } else if ((flags & 0x20) > 0) {
                        breakLoop = true;
                        region.unregisterInterest((Object)"ALL_KEYS");
                    } else {
                        region.unregisterInterest((Object)key);
                    }
                } else if (op.isKeySet()) {
                    breakLoop = true;
                    Set keySet = (flags & 0x100) > 0 ? region.keySet() : region.keySetOnServer();
                    Assert.assertNotNull((Object)keySet);
                    if ((flags & 1) == 0) {
                        Assert.assertEquals((long)numOps, (long)keySet.size());
                    }
                    for (int keyNum : indices) {
                        if ((flags & 1) > 0) {
                            Assert.assertFalse((boolean)keySet.contains(keys[keyNum]));
                            continue;
                        }
                        Assert.assertTrue((boolean)keySet.contains(keys[keyNum]));
                    }
                } else if (op.isQuery()) {
                    breakLoop = true;
                    SelectResults queryResults = region.query("SELECT DISTINCT * FROM " + region.getFullPath());
                    Assert.assertNotNull((Object)queryResults);
                    Set set = queryResults.asSet();
                    if ((flags & 1) == 0) {
                        Assert.assertEquals((long)numOps, (long)set.size());
                    }
                    for (int keyNum : indices) {
                        if ((flags & 1) > 0) {
                            Assert.assertFalse((boolean)set.contains(vals[keyNum]));
                            continue;
                        }
                        Assert.assertTrue((boolean)set.contains(vals[keyNum]));
                    }
                } else if (op.isExecuteCQ()) {
                    breakLoop = true;
                    QueryService queryService = SecurityTestUtils.getCache().getQueryService();
                    CqQuery cqQuery = queryService.getCq("cq1");
                    if (cqQuery == null) {
                        CqAttributesFactory cqFact = new CqAttributesFactory();
                        cqFact.addCqListener((CqListener)new AuthzCqListener());
                        CqAttributes cqAttrs = cqFact.create();
                        CqQuery cqQuery2 = queryService.newCq("cq1", "SELECT * FROM " + region.getFullPath(), cqAttrs);
                    }
                    if ((flags & 0x100) > 0) {
                        final AuthzCqListener listener = (AuthzCqListener)var21_44.getCqAttributes().getCqListener();
                        WaitCriterion ev = new WaitCriterion(){

                            @Override
                            public boolean done() {
                                if ((flags & 1) > 0) {
                                    return 0 == listener.getNumUpdates();
                                }
                                return numOps == listener.getNumUpdates();
                            }

                            @Override
                            public String description() {
                                return null;
                            }
                        };
                        GeodeAwaitility.await().untilAsserted((ThrowingRunnable)ev);
                        if ((flags & 1) > 0) {
                            Assert.assertEquals((long)0L, (long)listener.getNumUpdates());
                        } else {
                            Assert.assertEquals((long)numOps, (long)listener.getNumUpdates());
                            listener.checkPuts(vals, indices);
                        }
                        Assert.assertEquals((long)0L, (long)listener.getNumCreates());
                        Assert.assertEquals((long)0L, (long)listener.getNumDestroys());
                        Assert.assertEquals((long)0L, (long)listener.getNumOtherOps());
                        Assert.assertEquals((long)0L, (long)listener.getNumErrors());
                    } else {
                        CqResults cqResults = var21_44.executeWithInitialResults();
                        Assert.assertNotNull((Object)cqResults);
                        HashSet<Object> cqResultValues = new HashSet<Object>();
                        for (Object o : cqResults.asList()) {
                            Struct s = (Struct)o;
                            cqResultValues.add(s.get("value"));
                        }
                        Set cqResultSet = cqResults.asSet();
                        if ((flags & 1) == 0) {
                            Assert.assertEquals((long)numOps, (long)cqResultSet.size());
                        }
                        for (int keyNum : indices) {
                            if ((flags & 1) > 0) {
                                Assert.assertFalse((boolean)cqResultValues.contains(vals[keyNum]));
                                continue;
                            }
                            Assert.assertTrue((boolean)cqResultValues.contains(vals[keyNum]));
                        }
                    }
                } else if (op.isStopCQ()) {
                    breakLoop = true;
                    CqQuery cqQuery = SecurityTestUtils.getCache().getQueryService().getCq("cq1");
                    ((AuthzCqListener)cqQuery.getCqAttributes().getCqListener()).reset();
                    cqQuery.stop();
                } else if (op.isCloseCQ()) {
                    breakLoop = true;
                    CqQuery cqQuery = SecurityTestUtils.getCache().getQueryService().getCq("cq1");
                    ((AuthzCqListener)cqQuery.getCqAttributes().getCqListener()).reset();
                    cqQuery.close();
                } else if (op.isRegionClear()) {
                    breakLoop = true;
                    if ((flags & 0x100) > 0) {
                        region.localClear();
                    } else {
                        region.clear();
                    }
                } else if (op.isRegionCreate()) {
                    breakLoop = true;
                    DynamicRegionFactory drf = DynamicRegionFactory.get();
                    Region region2 = drf.createDynamicRegion(regionName, SUBREGION_NAME);
                    Assert.assertEquals((Object)"/AuthRegion/AuthSubregion", (Object)region2.getFullPath());
                } else if (op.isRegionDestroy()) {
                    breakLoop = true;
                    if ((flags & 0x100) > 0) {
                        region.localDestroyRegion();
                    } else if ((flags & 0x400) > 0) {
                        try {
                            DynamicRegionFactory.get().destroyDynamicRegion(region.getFullPath());
                        }
                        catch (RegionDestroyedException ex) {
                            System.out.println("doOp: sub-region " + region.getFullPath() + " already destroyed");
                            operationOmitted = true;
                        }
                    } else {
                        region.destroyRegion();
                    }
                } else {
                    Assert.fail((String)("doOp: Unhandled operation " + String.valueOf(op)));
                }
                if (expectedResult == 0 || operationOmitted || op.isUnregisterInterest()) continue;
                Assert.fail((String)("Expected an exception while performing operation op =" + String.valueOf(op) + "flags = " + OpFlags.description(flags)));
            }
            catch (Exception ex) {
                exceptionOccurred = true;
                if ((ex instanceof ServerConnectivityException || ex instanceof QueryInvocationTargetException || ex instanceof CqException) && expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    System.out.println("doOp: Got expected NotAuthorizedException when doing operation [" + String.valueOf(op) + "] with flags " + OpFlags.description(flags) + ": " + String.valueOf(ex.getCause()));
                    continue;
                }
                if (expectedResult == 5) {
                    System.out.println("doOp: Got expected exception when doing operation: " + String.valueOf(ex));
                    continue;
                }
                Assert.fail("doOp: Got unexpected exception when doing operation. Policy = " + String.valueOf(policy) + " flags = " + OpFlags.description(flags), ex);
            }
        }
        if (!exceptionOccurred && !operationOmitted && expectedResult != 0) {
            Assert.fail((String)("Expected an exception while performing operation: " + String.valueOf(op) + " flags = " + OpFlags.description(flags)));
        }
    }

    protected void executeOpBlock(List<OperationWithAction> opBlock, int port1, int port2, String authInit, Properties extraAuthProps, Properties extraAuthzProps, TestCredentialGenerator credentialGenerator, Random random) throws InterruptedException {
        for (OperationWithAction currentOp : opBlock) {
            OperationContext.OperationCode opCode = currentOp.getOperationCode();
            int opFlags = currentOp.getFlags();
            int clientNum = currentOp.getClientNum();
            VM clientVM = null;
            boolean useThisVM = false;
            switch (clientNum) {
                case 1: {
                    clientVM = client1;
                    break;
                }
                case 2: {
                    clientVM = client2;
                    break;
                }
                case 3: {
                    useThisVM = true;
                    break;
                }
                default: {
                    Assert.fail((String)("executeOpBlock: Unknown client number " + clientNum));
                }
            }
            System.out.println("executeOpBlock: performing operation number [" + currentOp.getOpNum() + "]: " + String.valueOf(currentOp));
            if ((opFlags & 0x1000) == 0) {
                boolean setupDynamicRegionFactory;
                String credentialsTypeStr;
                Properties opCredentials;
                Properties javaProps;
                int newRnd = random.nextInt(100) + 1;
                Object currentRegionName = "/AuthRegion";
                if ((opFlags & 0x400) > 0) {
                    currentRegionName = (String)currentRegionName + "/AuthSubregion";
                }
                OperationContext.OperationCode authOpCode = currentOp.getAuthzOperationCode();
                int[] indices = currentOp.getIndices();
                CredentialGenerator cGen = credentialGenerator.getCredentialGenerator();
                Properties properties = javaProps = cGen == null ? null : cGen.getJavaProperties();
                if ((opFlags & 2) > 0 || (opFlags & 0x2000) > 0) {
                    opCredentials = credentialGenerator.getDisallowedCredentials(new OperationContext.OperationCode[]{authOpCode}, new String[]{currentRegionName}, indices, newRnd);
                    credentialsTypeStr = " unauthorized " + String.valueOf(authOpCode);
                } else {
                    opCredentials = credentialGenerator.getAllowedCredentials(new OperationContext.OperationCode[]{opCode, authOpCode}, new String[]{currentRegionName}, indices, newRnd);
                    credentialsTypeStr = " authorized " + String.valueOf(authOpCode);
                }
                Properties clientProps = SecurityTestUtils.concatProperties(new Properties[]{opCredentials, extraAuthProps, extraAuthzProps});
                System.out.println("executeOpBlock: For client" + clientNum + credentialsTypeStr + " credentials: " + String.valueOf(opCredentials));
                boolean bl = setupDynamicRegionFactory = (opFlags & 0x4000) > 0;
                if (useThisVM) {
                    clientProps.put("serializable-object-filter", "org.apache.geode.security.templates.UsernamePrincipal");
                    SecurityTestUtils.createCacheClientWithDynamicRegion(authInit, clientProps, javaProps, 0, setupDynamicRegionFactory, 0);
                } else {
                    clientVM.invoke("SecurityTestUtils.createCacheClientWithDynamicRegion", () -> {
                        try {
                            DistributionConfig.class.getDeclaredMethod("getSerializableObjectFilter", new Class[0]);
                            clientProps.put("serializable-object-filter", "org.apache.geode.security.templates.UsernamePrincipal");
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        SecurityTestUtils.createCacheClientWithDynamicRegion(authInit, clientProps, javaProps, 0, setupDynamicRegionFactory, 0);
                    });
                }
            }
            int expectedResult = (opFlags & 2) > 0 ? 4 : ((opFlags & 8) > 0 ? 5 : 0);
            if (useThisVM) {
                ClientAuthorizationTestCase.doOp(opCode, currentOp.getIndices(), opFlags, expectedResult);
                continue;
            }
            int[] indices = currentOp.getIndices();
            clientVM.invoke("ClientAuthorizationTestCase.doOp", () -> ClientAuthorizationTestCase.doOp(opCode, indices, opFlags, expectedResult));
        }
    }

    protected AuthzCredentialGenerator getXmlAuthzGenerator() {
        XmlAuthzCredentialGenerator authzGen = new XmlAuthzCredentialGenerator();
        DummyCredentialGenerator cGen = new DummyCredentialGenerator();
        cGen.init();
        authzGen.init(cGen);
        return authzGen;
    }

    protected List<AuthzCredentialGenerator> getDummyGeneratorCombos() {
        ArrayList<AuthzCredentialGenerator> generators = new ArrayList<AuthzCredentialGenerator>();
        for (Object o : AuthzCredentialGenerator.ClassCode.getAll()) {
            AuthzCredentialGenerator.ClassCode authzClassCode = (AuthzCredentialGenerator.ClassCode)o;
            AuthzCredentialGenerator authzGen = AuthzCredentialGenerator.create(authzClassCode);
            if (authzGen == null) continue;
            DummyCredentialGenerator cGen = new DummyCredentialGenerator();
            cGen.init();
            if (!authzGen.init(cGen)) continue;
            generators.add(authzGen);
        }
        Assert.assertTrue((generators.size() > 0 ? 1 : 0) != 0);
        return generators;
    }

    protected void runOpsWithFailOver(OperationWithAction[] opCodes, String testName) throws InterruptedException {
        AuthzCredentialGenerator gen = this.getXmlAuthzGenerator();
        CredentialGenerator cGen = gen.getCredentialGenerator();
        Properties extraAuthProps = cGen.getSystemProperties();
        Properties javaProps = cGen.getJavaProperties();
        Properties extraAuthzProps = gen.getSystemProperties();
        String authenticator = cGen.getAuthenticator();
        String authInit = cGen.getAuthInit();
        String accessor = gen.getAuthorizationCallback();
        TestAuthzCredentialGenerator tgen = new TestAuthzCredentialGenerator(gen);
        System.out.println(testName + ": Using authinit: " + authInit);
        System.out.println(testName + ": Using authenticator: " + authenticator);
        System.out.println(testName + ": Using accessor: " + accessor);
        Properties serverProps = ClientAuthorizationTestCase.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
        List randomAvailableTCPPortKeepers = AvailablePortHelper.getRandomAvailableTCPPortKeepers((int)2);
        AvailablePort.Keeper port1Keeper = (AvailablePort.Keeper)randomAvailableTCPPortKeepers.get(0);
        AvailablePort.Keeper port2Keeper = (AvailablePort.Keeper)randomAvailableTCPPortKeepers.get(1);
        int port1 = port1Keeper.getPort();
        int port2 = port2Keeper.getPort();
        ArrayList<OperationWithAction> opBlock = new ArrayList<OperationWithAction>();
        Random rnd = new Random();
        for (int opNum = 0; opNum < opCodes.length; ++opNum) {
            OperationWithAction currentOp = opCodes[opNum];
            if (currentOp.equals(OperationWithAction.OPBLOCK_END) || currentOp.equals(OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                if (opBlock.size() <= 0) continue;
                port1Keeper.release();
                server1.invoke("createCacheServer", () -> ClientAuthorizationTestCase.createCacheServer(port1, serverProps, javaProps));
                server2.invoke("closeCache", () -> SecurityTestUtils.closeCache());
                this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                if (!currentOp.equals(OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                    port2Keeper.release();
                    server2.invoke("createCacheServer", () -> ClientAuthorizationTestCase.createCacheServer(port2, serverProps, javaProps));
                    server1.invoke("closeCache", () -> SecurityTestUtils.closeCache());
                    this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                }
                opBlock.clear();
                continue;
            }
            currentOp.setOpNum(opNum);
            opBlock.add(currentOp);
        }
    }

    protected static class OpFlags {
        public static final int NONE = 0;
        public static final int CHECK_FAIL = 1;
        public static final int CHECK_NOTAUTHZ = 2;
        public static final int CHECK_NOREGION = 4;
        public static final int CHECK_EXCEPTION = 8;
        public static final int USE_NEWVAL = 16;
        public static final int USE_ALL_KEYS = 32;
        public static final int USE_REGEX = 64;
        public static final int USE_LIST = 128;
        public static final int LOCAL_OP = 256;
        public static final int CHECK_NOKEY = 512;
        public static final int USE_SUBREGION = 1024;
        public static final int NO_CREATE_SUBREGION = 2048;
        public static final int USE_OLDCONN = 4096;
        public static final int USE_NOTAUTHZ = 8192;
        public static final int ENABLE_DRF = 16384;
        public static final int REGISTER_POLICY_NONE = 32768;
        public static final int USE_GET_ENTRY_IN_TX = 65536;

        protected OpFlags() {
        }

        public static String description(int f) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            if ((f & 1) != 0) {
                sb.append("CHECK_FAIL,");
            }
            if ((f & 2) != 0) {
                sb.append("CHECK_NOTAUTHZ,");
            }
            if ((f & 4) != 0) {
                sb.append("CHECK_NOREGION,");
            }
            if ((f & 8) != 0) {
                sb.append("CHECK_EXCEPTION,");
            }
            if ((f & 0x10) != 0) {
                sb.append("USE_NEWVAL,");
            }
            if ((f & 0x20) != 0) {
                sb.append("USE_ALL_KEYS,");
            }
            if ((f & 0x40) != 0) {
                sb.append("USE_REGEX,");
            }
            if ((f & 0x80) != 0) {
                sb.append("USE_LIST,");
            }
            if ((f & 0x100) != 0) {
                sb.append("LOCAL_OP,");
            }
            if ((f & 0x200) != 0) {
                sb.append("CHECK_NOKEY,");
            }
            if ((f & 0x400) != 0) {
                sb.append("USE_SUBREGION,");
            }
            if ((f & 0x800) != 0) {
                sb.append("NO_CREATE_SUBREGION,");
            }
            if ((f & 0x1000) != 0) {
                sb.append("USE_OLDCONN,");
            }
            if ((f & 0x2000) != 0) {
                sb.append("USE_NOTAUTHZ");
            }
            if ((f & 0x4000) != 0) {
                sb.append("ENABLE_DRF,");
            }
            if ((f & 0x8000) != 0) {
                sb.append("REGISTER_POLICY_NONE,");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static class AuthzCqListener
    implements CqListener {
        private final List<CqEvent> eventList = new ArrayList<CqEvent>();
        private int numCreates;
        private int numUpdates;
        private int numDestroys;
        private int numOtherOps;
        private int numErrors;

        public AuthzCqListener() {
            this.reset();
        }

        public void reset() {
            this.eventList.clear();
            this.numCreates = 0;
            this.numUpdates = 0;
            this.numErrors = 0;
        }

        public void onEvent(CqEvent aCqEvent) {
            Operation op = aCqEvent.getBaseOperation();
            if (op.isCreate()) {
                ++this.numCreates;
            } else if (op.isUpdate()) {
                ++this.numUpdates;
            } else if (op.isDestroy()) {
                ++this.numDestroys;
            } else {
                ++this.numOtherOps;
            }
            this.eventList.add(aCqEvent);
        }

        public void onError(CqEvent aCqEvent) {
            ++this.numErrors;
        }

        public void close() {
            this.eventList.clear();
        }

        public int getNumCreates() {
            return this.numCreates;
        }

        public int getNumUpdates() {
            return this.numUpdates;
        }

        public int getNumDestroys() {
            return this.numDestroys;
        }

        public int getNumOtherOps() {
            return this.numOtherOps;
        }

        public int getNumErrors() {
            return this.numErrors;
        }

        public void checkPuts(String[] vals, int[] indices) {
            for (int index : indices) {
                boolean foundKey = false;
                for (CqEvent event : this.eventList) {
                    if (!SecurityTestUtils.KEYS[index].equals(event.getKey())) continue;
                    Assert.assertEquals((Object)vals[index], (Object)event.getNewValue());
                    foundKey = true;
                    break;
                }
                Assert.assertTrue((boolean)foundKey);
            }
        }
    }

    protected static class OperationWithAction {
        private final OperationContext.OperationCode opCode;
        private final OperationContext.OperationCode authzOpCode;
        private final int clientNum;
        private final int flags;
        private int[] indices;
        private int opNum;
        public static final OperationWithAction OPBLOCK_END = new OperationWithAction(null, 4);
        public static final OperationWithAction OPBLOCK_NO_FAILOVER = new OperationWithAction(null, 5);

        private void setIndices(int numOps) {
            this.indices = new int[numOps];
            for (int index = 0; index < numOps; ++index) {
                this.indices[index] = index;
            }
        }

        public OperationWithAction(OperationContext.OperationCode opCode) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = 1;
            this.flags = 0;
            this.setIndices(4);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, int clientNum) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = clientNum;
            this.flags = 0;
            this.setIndices(4);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, int clientNum, int flags, int numOps) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.setIndices(numOps);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, OperationContext.OperationCode deniedOpCode, int clientNum, int flags, int numOps) {
            this.opCode = opCode;
            this.authzOpCode = deniedOpCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.setIndices(numOps);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, int clientNum, int flags, int[] indices) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.indices = indices;
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, OperationContext.OperationCode deniedOpCode, int clientNum, int flags, int[] indices) {
            this.opCode = opCode;
            this.authzOpCode = deniedOpCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.indices = indices;
            this.opNum = 0;
        }

        public OperationContext.OperationCode getOperationCode() {
            return this.opCode;
        }

        public OperationContext.OperationCode getAuthzOperationCode() {
            return this.authzOpCode;
        }

        public int getClientNum() {
            return this.clientNum;
        }

        public int getFlags() {
            return this.flags;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public int getOpNum() {
            return this.opNum;
        }

        public void setOpNum(int opNum) {
            this.opNum = opNum;
        }

        public String toString() {
            return "opCode:" + String.valueOf(this.opCode) + ",authOpCode:" + String.valueOf(this.authzOpCode) + ",clientNum:" + this.clientNum + ",flags:" + this.flags + ",numOps:" + this.indices.length + ",indices:" + ClientAuthorizationTestCase.indicesToString(this.indices);
        }
    }

    protected static interface TestCredentialGenerator {
        public Properties getAllowedCredentials(OperationContext.OperationCode[] var1, String[] var2, int[] var3, int var4);

        public Properties getDisallowedCredentials(OperationContext.OperationCode[] var1, String[] var2, int[] var3, int var4);

        public CredentialGenerator getCredentialGenerator();
    }

    protected static class TestAuthzCredentialGenerator
    implements TestCredentialGenerator {
        private final AuthzCredentialGenerator authzGen;

        public TestAuthzCredentialGenerator(AuthzCredentialGenerator authzGen) {
            this.authzGen = authzGen;
        }

        @Override
        public Properties getAllowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int[] keyIndices, int num) {
            return this.authzGen.getAllowedCredentials(opCodes, regionNames, num);
        }

        @Override
        public Properties getDisallowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int[] keyIndices, int num) {
            return this.authzGen.getDisallowedCredentials(opCodes, regionNames, num);
        }

        @Override
        public CredentialGenerator getCredentialGenerator() {
            return this.authzGen.getCredentialGenerator();
        }
    }
}

