/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import org.apache.geode.CancelException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.Distribution;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipTestHook;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.GMSMembership;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.WaitCriterion;
import org.awaitility.core.ThrowingRunnable;

public class MembershipManagerHelper {
    public static Distribution getDistribution(DistributedSystem sys) {
        InternalDistributedSystem isys = (InternalDistributedSystem)sys;
        ClusterDistributionManager dm = (ClusterDistributionManager)isys.getDM();
        return dm.getDistribution();
    }

    public static void beSickMember(DistributedSystem sys) {
        MembershipManagerHelper.getDistribution(sys).beSick();
    }

    public static void playDead(DistributedSystem sys) {
        try {
            MembershipManagerHelper.getDistribution(sys).playDead();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    public static DistributedMember getCoordinator(DistributedSystem sys) {
        return (DistributedMember)MembershipManagerHelper.getDistribution(sys).getView().getCoordinator();
    }

    public static DistributedMember getCreator(DistributedSystem sys) {
        return (DistributedMember)MembershipManagerHelper.getDistribution(sys).getView().getCreator();
    }

    public static DistributedMember getLeadMember(DistributedSystem sys) {
        return (DistributedMember)MembershipManagerHelper.getDistribution(sys).getView().getLeadMember();
    }

    public static void addTestHook(DistributedSystem sys, MembershipTestHook hook) {
        ((InternalDistributedSystem)sys).getDistributionManager().registerTestHook(hook);
    }

    public static void removeTestHook(DistributedSystem sys, MembershipTestHook hook) {
        ((InternalDistributedSystem)sys).getDistributionManager().unregisterTestHook(hook);
    }

    public static void addSurpriseMember(DistributedSystem sys, DistributedMember mbr, long birthTime) {
        MembershipManagerHelper.getDistribution(sys).addSurpriseMemberForTesting((InternalDistributedMember)mbr, birthTime);
    }

    public static void inhibitForcedDisconnectLogging(boolean b) {
        GMSMembership.inhibitForcedDisconnectLogging((boolean)b);
    }

    public static void waitForMemberDeparture(final DistributedSystem sys, final InternalDistributedMember member, final long timeout) {
        WaitCriterion ev = new WaitCriterion(){

            @Override
            public boolean done() {
                return !MembershipManagerHelper.getDistribution(sys).getView().contains((MemberIdentifier)member);
            }

            @Override
            public String description() {
                return "Waited over " + timeout + " ms for " + String.valueOf(member) + " to depart, but it didn't";
            }
        };
        GeodeAwaitility.await().untilAsserted((ThrowingRunnable)ev);
    }

    @VisibleForTesting
    public static void crashDistributedSystem(DistributedSystem msys) {
        msys.getLogWriter().info("crashing distributed system: " + String.valueOf(msys));
        Distribution mgr = MembershipManagerHelper.getDistribution(msys);
        MembershipManagerHelper.inhibitForcedDisconnectLogging(true);
        MembershipManagerHelper.beSickMember(msys);
        MembershipManagerHelper.playDead(msys);
        ((GMSMembership)mgr.getMembership()).getGMSManager().forceDisconnect("for testing");
        GeodeAwaitility.await().until(() -> !msys.isConnected());
        MembershipManagerHelper.inhibitForcedDisconnectLogging(false);
    }

    public static void disableDisconnectOnQuorumLossForTesting(DistributedSystem msys) {
        msys.getLogWriter().info("crashing distributed system: " + String.valueOf(msys));
        Distribution mgr = MembershipManagerHelper.getDistribution(msys);
        ((GMSMembership)mgr.getMembership()).disableDisconnectOnQuorumLossForTesting();
    }
}

