/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.VMEventListener;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.rules.RemoteInvoker;
import org.apache.geode.test.junit.rules.DiskDirRule;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.apache.geode.test.junit.rules.serializable.SerializableTestName;
import org.apache.geode.test.junit.rules.serializable.SerializableTestRule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.Description;

public class DistributedDiskDirRule
extends DiskDirRule
implements SerializableTestRule {
    private static volatile DistributedDiskDirRuleData data;
    private final SerializableTemporaryFolder temporaryFolder;
    private final SerializableTestName testName;
    private final int vmCount;
    private final RemoteInvoker invoker;
    private final VMEventListener vmEventListener;
    private String testClassName;

    public DistributedDiskDirRule() {
        this(VM.DEFAULT_VM_COUNT, new SerializableTemporaryFolder(), new SerializableTestName());
    }

    public DistributedDiskDirRule(int vmCount) {
        this(vmCount, new SerializableTemporaryFolder(), new SerializableTestName());
    }

    private DistributedDiskDirRule(int vmCount, SerializableTemporaryFolder temporaryFolder, SerializableTestName testName) {
        this(vmCount, temporaryFolder, testName, new RemoteInvoker());
    }

    private DistributedDiskDirRule(int vmCount, SerializableTemporaryFolder temporaryFolder, SerializableTestName testName, RemoteInvoker invoker) {
        super(null, null);
        this.temporaryFolder = temporaryFolder;
        this.testName = testName;
        this.vmCount = vmCount;
        this.invoker = invoker;
        this.vmEventListener = new InternalVMEventListener();
    }

    public File getDiskDirFor(VM vm) {
        return new File((String)vm.invoke(() -> System.getProperty("geode.defaultDiskDirs")));
    }

    @Override
    protected void before(Description description) throws Exception {
        DUnitLauncher.launchIfNeeded(this.vmCount);
        VM.addVMEventListener(this.vmEventListener);
        this.initializeHelperRules(description);
        this.testClassName = this.getTestClassName(description);
        this.invoker.invokeInEveryVMAndController(() -> this.doBefore(this));
    }

    @Override
    protected void after(Description description) {
        VM.removeVMEventListener(this.vmEventListener);
        this.invoker.invokeInEveryVMAndController(() -> this.doAfter());
    }

    private String getDiskDirName(String testClass) {
        return "VM" + VM.getCurrentVMNum() + "-" + testClass + "_" + this.testName.getMethodName() + "-diskDirs";
    }

    private void initializeHelperRules(Description description) throws Exception {
        Method method;
        if (this.temporaryFolder != null) {
            method = TemporaryFolder.class.getDeclaredMethod("before", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.temporaryFolder, new Object[0]);
        }
        if (this.testName != null) {
            method = TestName.class.getDeclaredMethod("starting", Description.class);
            method.setAccessible(true);
            method.invoke((Object)this.testName, description);
        }
    }

    private void afterCreateVM(VM vm) {
        vm.invoke(() -> this.doBefore(this));
    }

    private void afterBounceVM(VM vm) {
        vm.invoke(() -> this.doBefore(this));
    }

    private void doBefore(DistributedDiskDirRule diskDirRule) throws Exception {
        data = new DistributedDiskDirRuleData(diskDirRule);
        Optional value = SystemPropertyHelper.getProductStringProperty((String)"defaultDiskDirs");
        value.ifPresent(s -> data.setOriginalValue((String)s));
        File diskDir = new File(data.temporaryFolder().getRoot(), this.getDiskDirName(this.testClassName));
        if (!diskDir.exists()) {
            Files.createDirectory(diskDir.toPath(), new FileAttribute[0]);
        }
        System.setProperty("geode.defaultDiskDirs", diskDir.getAbsolutePath());
    }

    private void doAfter() {
        if (data == null) {
            throw new Error("Failed to invoke " + ((Object)((Object)this)).getClass().getSimpleName() + ".before in VM-" + VM.getCurrentVMNum() + ". Rule does not support VM.bounce().");
        }
        if (data.originalValue() == null) {
            System.clearProperty("geode.defaultDiskDirs");
        } else {
            System.setProperty("geode.defaultDiskDirs", data.originalValue());
        }
    }

    private class InternalVMEventListener
    implements VMEventListener,
    Serializable {
        private InternalVMEventListener() {
        }

        @Override
        public void afterCreateVM(VM vm) {
            DistributedDiskDirRule.this.afterCreateVM(vm);
        }

        @Override
        public void afterBounceVM(VM vm) {
            DistributedDiskDirRule.this.afterBounceVM(vm);
        }
    }

    private static class DistributedDiskDirRuleData {
        private final SerializableTemporaryFolder temporaryFolder;
        private final SerializableTestName testName;
        private volatile String originalValue;

        DistributedDiskDirRuleData(DistributedDiskDirRule diskDirRule) {
            this(diskDirRule.temporaryFolder, diskDirRule.testName);
        }

        private DistributedDiskDirRuleData(SerializableTemporaryFolder temporaryFolder, SerializableTestName testName) {
            this.temporaryFolder = temporaryFolder;
            this.testName = testName;
        }

        SerializableTemporaryFolder temporaryFolder() {
            return this.temporaryFolder;
        }

        SerializableTestName testName() {
            return this.testName;
        }

        String originalValue() {
            return this.originalValue;
        }

        void setOriginalValue(String originalValue) {
            this.originalValue = originalValue;
        }
    }
}

