/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache30.CacheTestCase;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.SerializableCallable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.WaitCriterion;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.geode.test.dunit.rules.DistributedRestoreSystemProperties;
import org.awaitility.core.ThrowingRunnable;
import org.junit.Rule;

public abstract class ManagementTestBase
extends CacheTestCase {
    private static final int MAX_WAIT = 70000;
    protected static ManagementService managementService;
    protected static List<VM> managedNodeList;
    protected static VM managingNode;
    protected static VM managedNode1;
    protected static VM managedNode2;
    protected static VM managedNode3;
    @Rule
    public DistributedRestoreSystemProperties restoreSystemProperties = new DistributedRestoreSystemProperties();

    @Override
    public final void postSetUp() throws Exception {
        JUnit4DistributedTestCase.disconnectAllFromDS();
        Host host = Host.getHost(0);
        managingNode = host.getVM(0);
        managedNode1 = host.getVM(1);
        managedNode2 = host.getVM(2);
        managedNode3 = host.getVM(3);
        managedNodeList = new ArrayList<VM>();
        managedNodeList.add(managedNode1);
        managedNodeList.add(managedNode2);
        managedNodeList.add(managedNode3);
        this.postSetUpManagementTestBase();
    }

    protected void postSetUpManagementTestBase() throws Exception {
    }

    @Override
    public final void preTearDownCacheTestCase() throws Exception {
        this.preTearDownManagementTestBase();
    }

    @Override
    public final void postTearDownCacheTestCase() throws Exception {
        managementService = null;
        this.postTearDownManagementTestBase();
    }

    protected void preTearDownManagementTestBase() throws Exception {
    }

    protected void postTearDownManagementTestBase() throws Exception {
    }

    protected void initManagement(boolean managingNodeFirst) {
        if (managingNodeFirst) {
            this.createManagementCache(managingNode);
            this.startManagingNode(managingNode);
            for (VM vm : managedNodeList) {
                this.createCache(vm);
            }
        } else {
            for (VM vm : managedNodeList) {
                this.createCache(vm);
            }
            this.createManagementCache(managingNode);
            this.startManagingNode(managingNode);
        }
    }

    protected void createCache(VM vm) {
        vm.invoke("Create Cache", () -> this.createCache(false));
    }

    protected void createCache(VM vm, Properties props) {
        vm.invoke("Create Cache", () -> this.createCache(props));
    }

    private Cache createCache(Properties config) {
        InternalCache cache = this.getCache(config);
        managementService = ManagementService.getManagementService((Cache)cache);
        return cache;
    }

    protected Cache createCache(boolean isManager) {
        Properties props = new Properties();
        if (isManager) {
            props.setProperty("jmx-manager", "true");
            props.setProperty("jmx-manager-start", "false");
            props.setProperty("jmx-manager-port", "0");
            props.setProperty("jmx-manager-http-port", "0");
        }
        props.setProperty("enable-time-statistics", "true");
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("log-file", JUnit4DistributedTestCase.getTestMethodName() + "-.log");
        InternalCache cache = this.getCache(props);
        managementService = ManagementService.getManagementService((Cache)cache);
        return cache;
    }

    protected void createManagementCache(VM vm) {
        vm.invoke("Create Management Cache", () -> this.createCache(true));
    }

    protected void closeCache(VM vm) {
        vm.invoke("Close Cache", () -> {
            InternalDistributedSystem ds;
            GemFireCacheImpl existingInstance = GemFireCacheImpl.getInstance();
            if (existingInstance != null) {
                existingInstance.close();
            }
            if ((ds = InternalDistributedSystem.getConnectedInstance()) != null) {
                ds.disconnect();
            }
        });
    }

    protected String getMemberId(VM vm) {
        return (String)vm.invoke("getMemberId", () -> {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            return cache.getDistributedSystem().getDistributedMember().getId();
        });
    }

    protected static void waitForProxy(final ObjectName objectName, final Class interfaceClass) {
        GeodeAwaitility.await().untilAsserted((ThrowingRunnable)new WaitCriterion(){

            @Override
            public String description() {
                return "Waiting for the proxy of " + objectName.getCanonicalName() + " to get propagated to Manager";
            }

            @Override
            public boolean done() {
                SystemManagementService service = (SystemManagementService)managementService;
                return service.getMBeanProxy(objectName, interfaceClass) != null;
            }
        });
    }

    protected void startManagingNode(VM vm) {
        vm.invoke("Start Being Managing Node", () -> {
            GemFireCacheImpl existingCache = GemFireCacheImpl.getInstance();
            managementService = ManagementService.getManagementService((Cache)existingCache);
            SystemManagementService service = (SystemManagementService)managementService;
            service.createManager();
            service.startManager();
        });
    }

    protected void stopManagingNode(VM vm) {
        vm.invoke("Stop Being Managing Node", () -> {
            GemFireCacheImpl existingCache = GemFireCacheImpl.getInstance();
            if (existingCache != null && !existingCache.isClosed() && managementService.isManager()) {
                managementService.stopManager();
            }
        });
    }

    protected static List<VM> getManagedNodeList() {
        return managedNodeList;
    }

    protected static VM getManagingNode() {
        return managingNode;
    }

    protected static ManagementService getManagementService() {
        return managementService;
    }

    protected void createLocalRegion(VM vm, String localRegionName) {
        vm.invoke("Create Local region", () -> {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            RegionFactory factory = cache.createRegionFactory(RegionShortcut.LOCAL);
            factory.create(localRegionName);
        });
    }

    protected void createPartitionRegion(VM vm, String partitionRegionName) {
        vm.invoke("Create Partitioned region", () -> {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            RegionFactory factory = cache.createRegionFactory(RegionShortcut.PARTITION_REDUNDANT);
            factory.create(partitionRegionName);
        });
    }

    protected static void waitForRefresh(final int expectedRefreshCount, final ObjectName objectName) {
        final ManagementService service = ManagementTestBase.getManagementService();
        GeodeAwaitility.await().untilAsserted((ThrowingRunnable)new WaitCriterion(){
            private int actualRefreshCount = 0;
            private long lastRefreshTime = service.getLastUpdateTime(objectName);

            @Override
            public String description() {
                return "Waiting For Proxy Refresh Count = " + expectedRefreshCount;
            }

            @Override
            public boolean done() {
                long newRefreshTime = service.getLastUpdateTime(objectName);
                if (newRefreshTime > this.lastRefreshTime) {
                    this.lastRefreshTime = newRefreshTime;
                    ++this.actualRefreshCount;
                }
                return this.actualRefreshCount >= expectedRefreshCount;
            }
        });
    }

    protected DistributedMember getMember(VM vm) {
        SerializableCallable getMember = new SerializableCallable("Get Member"){

            @Override
            public Object call() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        return (DistributedMember)vm.invoke(getMember);
    }

    protected <T> T getMBeanProxy(ObjectName objectName, Class<T> interfaceClass) {
        SystemManagementService service = (SystemManagementService)ManagementService.getManagementService((Cache)this.getCache());
        return (T)service.getMBeanProxy(objectName, interfaceClass);
    }
}

