/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.ChildVMLauncher;
import org.apache.geode.test.dunit.internal.ProcessHolder;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.internal.VMEventNotifier;

public abstract class Host
implements Serializable {
    private static final List<Host> hosts = new ArrayList<Host>();
    private static VM locator;
    private final String hostName;
    private final List<VM> vms;
    private final transient VMEventNotifier vmEventNotifier;

    public static int getHostCount() {
        return hosts.size();
    }

    protected static void addHost(Host host) {
        hosts.add(host);
    }

    public static Host getHost(int whichHost) {
        int size = hosts.size();
        if (whichHost >= size) {
            String message = "Cannot request host " + whichHost + ".  There are only " + size + " hosts.";
            throw new IllegalArgumentException(message);
        }
        return hosts.get(whichHost);
    }

    public static void setAllVMsToCurrentVersion() {
        int numHosts = Host.getHostCount();
        for (int hostIndex = 0; hostIndex < numHosts; ++hostIndex) {
            Host host = Host.getHost(hostIndex);
            int numVMs = host.getVMCount();
            for (int i = 0; i < numVMs; ++i) {
                try {
                    host.getVM("000", i);
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    protected Host(String hostName, VMEventNotifier vmEventNotifier) {
        if (hostName == null) {
            String message = "Cannot create a Host with a null name";
            throw new NullPointerException(message);
        }
        this.hostName = hostName;
        this.vms = new ArrayList<VM>();
        this.vmEventNotifier = vmEventNotifier;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getVMCount() {
        return this.vms.size();
    }

    public VM getVM(int n) {
        int size = this.vms.size();
        if (n >= size) {
            String s = "Cannot request VM " + n + ".  There are only " + size + " VMs on " + this;
            throw new IllegalArgumentException(s);
        }
        VM vm = this.vms.get(n);
        vm.makeAvailable();
        return vm;
    }

    public List<VM> getAllVMs() {
        return new ArrayList<VM>(this.vms);
    }

    public VM getVM(String version, int n) {
        throw new UnsupportedOperationException("Not supported in this implementation of Host");
    }

    protected void addVM(int vmid, RemoteDUnitVMIF client, ProcessHolder processHolder, ChildVMLauncher childVMLauncher) {
        VM vm = new VM(this, vmid, client, processHolder, childVMLauncher);
        this.vms.add(vm);
        this.vmEventNotifier.notifyAfterCreateVM(vm);
    }

    public static VM getLocator() {
        return locator;
    }

    private static void setLocator(VM l) {
        locator = l;
    }

    protected void addLocator(int vmid, RemoteDUnitVMIF client, ProcessHolder processHolder, ChildVMLauncher childVMLauncher) {
        Host.setLocator(new VM(this, vmid, client, processHolder, childVMLauncher));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Host ");
        sb.append(this.getHostName());
        sb.append(" with ");
        sb.append(this.getVMCount());
        sb.append(" VMs");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Host) {
            return ((Host)o).getHostName().equals(this.getHostName());
        }
        return false;
    }

    public int hashCode() {
        return this.getHostName().hashCode();
    }

    VMEventNotifier getVMEventNotifier() {
        return this.vmEventNotifier;
    }
}

