/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;

public class ClientCacheRule
extends SerializableExternalResource {
    private ClientCache cache;
    private ClientCacheFactory cacheFactory;
    private Consumer<ClientCacheFactory> cacheSetup;
    private Properties properties = new Properties();

    public ClientCacheRule() {
        this.properties.setProperty("mcast-port", "0");
    }

    public ClientCacheRule withProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public ClientCacheRule withProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ClientCacheRule withCacheSetup(Consumer<ClientCacheFactory> setup) {
        this.cacheSetup = setup;
        return this;
    }

    public void before() throws Exception {
        this.cacheFactory = new ClientCacheFactory(this.properties);
        this.cacheSetup.accept(this.cacheFactory);
        this.cache = this.cacheFactory.create();
    }

    public void after() {
        if (this.cache != null) {
            this.cache.close();
        }
        SocketCreatorFactory.close();
    }

    public ClientCache getCache() {
        return this.cache;
    }
}

