/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.RemoteInvoker;
import org.apache.geode.test.dunit.standalone.DUnitLauncher;
import org.apache.geode.test.junit.rules.DiskDirRule;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.apache.geode.test.junit.rules.serializable.SerializableTestName;
import org.apache.geode.test.junit.rules.serializable.SerializableTestRule;
import org.assertj.core.api.Assertions;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.Description;

public class DistributedDiskDirRule
extends DiskDirRule
implements SerializableTestRule {
    private static volatile DistributedDiskDirRuleData data;
    private final SerializableTemporaryFolder temporaryFolder;
    private final SerializableTestName testName;
    private final RemoteInvoker invoker;
    private volatile int beforeVmCount;

    public DistributedDiskDirRule() {
        this(new Builder());
    }

    public DistributedDiskDirRule(SerializableTemporaryFolder temporaryFolder) {
        this(new Builder().temporaryFolder(temporaryFolder));
    }

    public DistributedDiskDirRule(SerializableTestName testName) {
        this(new Builder().testName(testName));
    }

    public DistributedDiskDirRule(SerializableTemporaryFolder temporaryFolder, SerializableTestName testName) {
        this(new Builder().temporaryFolder(temporaryFolder).testName(testName));
    }

    public DistributedDiskDirRule(Builder builder) {
        this(builder, new RemoteInvoker());
    }

    protected DistributedDiskDirRule(Builder builder, RemoteInvoker invoker) {
        this(builder.initializeHelperRules, builder.temporaryFolder, builder.testName, invoker);
    }

    protected DistributedDiskDirRule(boolean initializeHelperRules, SerializableTemporaryFolder temporaryFolder, SerializableTestName testName, RemoteInvoker invoker) {
        super(initializeHelperRules, null, null);
        this.temporaryFolder = temporaryFolder;
        this.testName = testName;
        this.invoker = invoker;
    }

    public File getDiskDirFor(VM vm) {
        return new File((String)vm.invoke(() -> System.getProperty("geode.defaultDiskDirs")));
    }

    @Override
    protected void before(Description description) throws Exception {
        DUnitLauncher.launchIfNeeded();
        this.beforeVmCount = this.getVMCount();
        if (this.initializeHelperRules) {
            this.initializeHelperRules(description);
        }
        this.invoker.invokeInEveryVMAndController(() -> this.doBefore(this, description));
    }

    @Override
    protected void initializeHelperRules(Description description) throws Exception {
        Method method;
        if (this.temporaryFolder != null) {
            method = TemporaryFolder.class.getDeclaredMethod("before", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.temporaryFolder, new Object[0]);
        }
        if (this.testName != null) {
            method = TestName.class.getDeclaredMethod("starting", Description.class);
            method.setAccessible(true);
            method.invoke((Object)this.testName, description);
        }
    }

    @Override
    protected void after(Description description) {
        Assertions.assertThat((int)this.getVMCount()).isEqualTo(this.beforeVmCount);
        this.invoker.invokeInEveryVMAndController(() -> this.doAfter());
    }

    @Override
    protected String getDiskDirName(String testClass) {
        return "VM" + VM.getCurrentVMNum() + "-" + testClass + "_" + this.testName.getMethodName() + "-diskDirs";
    }

    private void doBefore(DistributedDiskDirRule diskDirRule, Description description) throws Exception {
        data = new DistributedDiskDirRuleData(diskDirRule);
        Optional value = SystemPropertyHelper.getProductStringProperty((String)"defaultDiskDirs");
        value.ifPresent(s -> data.setOriginalValue((String)s));
        File diskDir = data.temporaryFolder().newFolder(this.getDiskDirName(this.getTestClassName(description)));
        System.setProperty("geode.defaultDiskDirs", diskDir.getAbsolutePath());
    }

    private void doAfter() {
        if (data == null) {
            throw new Error("Failed to invoke " + ((Object)((Object)this)).getClass().getSimpleName() + ".before in VM-" + VM.getCurrentVMNum() + ". Rule does not support VM.bounce().");
        }
        if (data.originalValue() == null) {
            System.clearProperty("geode.defaultDiskDirs");
        } else {
            System.setProperty("geode.defaultDiskDirs", data.originalValue());
        }
    }

    private int getVMCount() {
        try {
            return Host.getHost(0).getVMCount();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("DUnit VMs have not been launched");
        }
    }

    public static class Builder {
        private boolean initializeHelperRules = true;
        private SerializableTemporaryFolder temporaryFolder = new SerializableTemporaryFolder();
        private SerializableTestName testName = new SerializableTestName();

        public Builder initializeHelperRules(boolean value) {
            this.initializeHelperRules = value;
            return this;
        }

        public Builder temporaryFolder(SerializableTemporaryFolder temporaryFolder) {
            this.temporaryFolder = temporaryFolder;
            return this;
        }

        public Builder testName(SerializableTestName testName) {
            this.testName = testName;
            return this;
        }

        public DistributedDiskDirRule build() {
            return new DistributedDiskDirRule(this);
        }
    }

    private static class DistributedDiskDirRuleData {
        private final SerializableTemporaryFolder temporaryFolder;
        private final SerializableTestName testName;
        private volatile String originalValue;

        DistributedDiskDirRuleData(DistributedDiskDirRule diskDirRule) {
            this(diskDirRule.temporaryFolder, diskDirRule.testName);
        }

        private DistributedDiskDirRuleData(SerializableTemporaryFolder temporaryFolder, SerializableTestName testName) {
            this.temporaryFolder = temporaryFolder;
            this.testName = testName;
        }

        SerializableTemporaryFolder temporaryFolder() {
            return this.temporaryFolder;
        }

        SerializableTestName testName() {
            return this.testName;
        }

        String originalValue() {
            return this.originalValue;
        }

        void setOriginalValue(String originalValue) {
            this.originalValue = originalValue;
        }
    }
}

