/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Properties;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ChangeLogLevelCommandDUnitTestBase {
    private static final String MANAGER_NAME = "Manager";
    private static final String SERVER1_NAME = "Server1";
    private static final String SERVER2_NAME = "Server2";
    private static final String GROUP0 = "Group0";
    private static final String GROUP1 = "Group1";
    private static final String GROUP2 = "Group2";
    protected static MemberVM locator;
    @ClassRule
    public static ClusterStartupRule clusterStartupRule;
    @ClassRule
    public static GfshCommandRule gfsh;

    @BeforeClass
    public static void setup() throws Exception {
        Properties managerProps = new Properties();
        managerProps.setProperty("name", MANAGER_NAME);
        managerProps.setProperty("groups", GROUP0);
        locator = clusterStartupRule.startLocatorVM(0, l -> (LocatorStarterRule)((LocatorStarterRule)l.withHttpService()).withProperties(managerProps));
        Properties server1Props = new Properties();
        server1Props.setProperty("name", SERVER1_NAME);
        server1Props.setProperty("groups", GROUP1);
        clusterStartupRule.startServerVM(1, server1Props, locator.getPort());
        Properties server2Props = new Properties();
        server2Props.setProperty("name", SERVER2_NAME);
        server2Props.setProperty("groups", GROUP2);
        clusterStartupRule.startServerVM(2, server2Props, locator.getPort());
    }

    @Before
    public void before() throws Exception {
        gfsh.connectAndVerify(locator.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    @After
    public void after() throws Exception {
        gfsh.disconnect();
    }

    @Test
    public void testChangeLogLevelForGroups() {
        String commandString = "change loglevel --loglevel=finer --groups=Group1,Group2";
        gfsh.executeAndAssertThat(commandString).statusIsSuccess().containsOutput(new String[]{SERVER1_NAME, SERVER2_NAME}).doesNotContainOutput(new String[]{MANAGER_NAME});
    }

    @Test
    public void testChangeLogLevelForGroup() {
        String commandString = "change loglevel --loglevel=finer --groups=Group1";
        gfsh.executeAndAssertThat(commandString).statusIsSuccess().containsOutput(new String[]{SERVER1_NAME}).doesNotContainOutput(new String[]{SERVER2_NAME, MANAGER_NAME});
    }

    @Test
    public void testChangeLogLevelForMembers() {
        String commandString = "change loglevel --loglevel=finer --members=Server1,Server2";
        gfsh.executeAndAssertThat(commandString).statusIsSuccess().containsOutput(new String[]{SERVER1_NAME, SERVER2_NAME}).doesNotContainOutput(new String[]{MANAGER_NAME});
    }

    @Test
    public void testChangeLogLevelForMember() {
        String commandString = "change loglevel --loglevel=finer --members=Server1";
        gfsh.executeAndAssertThat(commandString).statusIsSuccess().containsOutput(new String[]{SERVER1_NAME}).doesNotContainOutput(new String[]{SERVER2_NAME, MANAGER_NAME});
    }

    @Test
    public void testChangeLogLevelForInvalidMember() {
        String commandString = "change loglevel --loglevel=finer --members=NotAValidMember";
        gfsh.executeAndAssertThat(commandString).statusIsError().containsOutput(new String[]{"No members were found matching the given member IDs or groups."});
    }

    static {
        clusterStartupRule = new ClusterStartupRule();
        gfsh = new GfshCommandRule();
    }
}

