/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.Authenticator;
import org.apache.geode.security.templates.PKCSPrincipal;
import org.apache.logging.log4j.Logger;

public class PKCSAuthenticator
implements Authenticator {
    private static final Logger logger = LogService.getLogger();
    public static final String PUBLIC_KEY_FILE = "security-publickey-filepath";
    public static final String PUBLIC_KEYSTORE_PASSWORD = "security-publickey-pass";
    private String pubKeyFilePath;
    private String pubKeyPass;
    private Map aliasCertificateMap;
    private LogWriter systemLogWriter;
    private LogWriter securityLogWriter;

    public static Authenticator create() {
        return new PKCSAuthenticator();
    }

    public void init(Properties securityProperties, LogWriter systemLogWriter, LogWriter securityLogWriter) throws AuthenticationFailedException {
        this.systemLogWriter = systemLogWriter;
        this.securityLogWriter = securityLogWriter;
        this.pubKeyFilePath = securityProperties.getProperty(PUBLIC_KEY_FILE);
        if (this.pubKeyFilePath == null) {
            throw new AuthenticationFailedException("PKCSAuthenticator: property security-publickey-filepath not specified as the public key file.");
        }
        this.pubKeyPass = securityProperties.getProperty(PUBLIC_KEYSTORE_PASSWORD);
        this.aliasCertificateMap = new HashMap();
        this.populateMap();
    }

    public Principal authenticate(Properties credentials, DistributedMember member) throws AuthenticationFailedException {
        String alias = (String)credentials.get("security-alias");
        if (alias == null || alias.length() <= 0) {
            throw new AuthenticationFailedException("No alias received");
        }
        try {
            X509Certificate cert = this.getCertificate(alias);
            if (cert == null) {
                throw this.newException("No certificate found for alias:" + alias);
            }
            byte[] signatureBytes = (byte[])credentials.get("security-signature");
            if (signatureBytes == null) {
                throw this.newException("signature data property [security-signature] not provided");
            }
            Signature sig = Signature.getInstance(cert.getSigAlgName());
            sig.initVerify(cert);
            sig.update(alias.getBytes(StandardCharsets.UTF_8));
            if (!sig.verify(signatureBytes)) {
                throw this.newException("verification of client signature failed");
            }
            return new PKCSPrincipal(alias);
        }
        catch (Exception ex) {
            throw this.newException(ex.toString(), ex);
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMap() {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            char[] passPhrase = this.pubKeyPass != null ? this.pubKeyPass.toCharArray() : null;
            try (FileInputStream keyStoreFile = new FileInputStream(this.pubKeyFilePath);){
                keyStore.load(keyStoreFile, passPhrase);
            }
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate cert = keyStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                this.aliasCertificateMap.put(alias, cert);
            }
        }
        catch (Exception e) {
            throw new AuthenticationFailedException("Exception while getting public keys: " + e.getMessage(), (Throwable)e);
        }
    }

    private AuthenticationFailedException newException(String message, Exception cause) {
        String fullMessage = "PKCSAuthenticator: Authentication of client failed due to: " + message;
        if (cause != null) {
            return new AuthenticationFailedException(fullMessage, (Throwable)cause);
        }
        return new AuthenticationFailedException(fullMessage);
    }

    private AuthenticationFailedException newException(String message) {
        return this.newException(message, null);
    }

    private X509Certificate getCertificate(String alias) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.aliasCertificateMap.containsKey(alias)) {
            return (X509Certificate)this.aliasCertificateMap.get(alias);
        }
        return null;
    }
}

