/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.generator.CredentialGenerator;
import org.apache.geode.security.generator.DummyAuthzCredentialGenerator;
import org.apache.geode.security.generator.XmlAuthzCredentialGenerator;
import org.apache.geode.security.templates.DummyAuthorization;
import org.apache.geode.security.templates.XmlAuthorization;
import org.apache.logging.log4j.Logger;

public abstract class AuthzCredentialGenerator {
    private static final Logger logger = LogService.getLogger();
    protected CredentialGenerator generator;
    private Properties systemProperties;

    public static AuthzCredentialGenerator create(ClassCode classCode) {
        switch (classCode.classType) {
            case 1: {
                return new DummyAuthzCredentialGenerator();
            }
            case 2: {
                return new XmlAuthzCredentialGenerator();
            }
        }
        return null;
    }

    public boolean init(CredentialGenerator generator) {
        this.generator = generator;
        try {
            this.systemProperties = this.init();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public CredentialGenerator getCredentialGenerator() {
        return this.generator;
    }

    protected abstract Properties init() throws IllegalArgumentException;

    public abstract ClassCode classCode();

    public abstract String getAuthorizationCallback();

    public Properties getAllowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        int numTries = this.getNumPrincipalTries(opCodes, regionNames);
        if (numTries <= 0) {
            numTries = 1;
        }
        for (int tries = 0; tries < numTries; ++tries) {
            Principal principal = this.getAllowedPrincipal(opCodes, regionNames, (index + tries) % numTries);
            try {
                return this.generator.getValidCredentials(principal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        return null;
    }

    public Properties getDisallowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        int numTries = this.getNumPrincipalTries(opCodes, regionNames);
        if (numTries <= 0) {
            numTries = 1;
        }
        for (int tries = 0; tries < numTries; ++tries) {
            Principal principal = this.getDisallowedPrincipal(opCodes, regionNames, (index + tries) % numTries);
            try {
                return this.generator.getValidCredentials(principal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        return null;
    }

    protected abstract int getNumPrincipalTries(OperationContext.OperationCode[] var1, String[] var2);

    protected abstract Principal getAllowedPrincipal(OperationContext.OperationCode[] var1, String[] var2, int var3);

    protected abstract Principal getDisallowedPrincipal(OperationContext.OperationCode[] var1, String[] var2, int var3);

    public static class ClassCode {
        private static byte nextOrdinal = 0;
        private static final byte ID_DUMMY = 1;
        private static final byte ID_XML = 2;
        private static final ClassCode[] VALUES = new ClassCode[10];
        private static final Map CODE_NAME_MAP = new HashMap();
        public static final ClassCode DUMMY = new ClassCode(DummyAuthorization.class.getName() + ".create", 1);
        public static final ClassCode XML = new ClassCode(XmlAuthorization.class.getName() + ".create", 2);
        private final String name;
        private final byte ordinal;
        private final byte classType;

        private ClassCode(String name, byte classType) {
            this.name = name;
            this.classType = classType;
            byte by = nextOrdinal;
            nextOrdinal = (byte)(by + 1);
            this.ordinal = by;
            ClassCode.VALUES[this.ordinal] = this;
            CODE_NAME_MAP.put(name, this);
        }

        public boolean isDummy() {
            return this.classType == 1;
        }

        public boolean isXml() {
            return this.classType == 2;
        }

        public static ClassCode fromOrdinal(byte ordinal) {
            return VALUES[ordinal];
        }

        public static ClassCode parse(String operationName) {
            return (ClassCode)CODE_NAME_MAP.get(operationName);
        }

        public static List getAll() {
            ArrayList codes = new ArrayList();
            for (Object o : CODE_NAME_MAP.values()) {
                codes.add(o);
            }
            return codes;
        }

        public byte toOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClassCode)) {
                return false;
            }
            ClassCode other = (ClassCode)obj;
            return other.ordinal == this.ordinal;
        }

        public boolean equals(ClassCode opCode) {
            return opCode != null && opCode.ordinal == this.ordinal;
        }

        public int hashCode() {
            return this.ordinal;
        }
    }
}

