/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public class ProcessHolder {
    private final Process process;
    private volatile boolean killed = false;

    public ProcessHolder(Process process) {
        this.process = process;
    }

    public void kill() {
        this.killed = true;
        this.process.destroy();
    }

    public void killForcibly() {
        this.killed = true;
        this.process.destroyForcibly();
    }

    public void waitFor() throws InterruptedException {
        this.process.waitFor();
    }

    public void waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        this.process.waitFor(timeout, unit);
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public boolean isKilled() {
        return this.killed;
    }

    public boolean isAlive() {
        return !this.killed && this.process.isAlive();
    }
}

