/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.security.Principal;
import java.util.Properties;
import org.apache.geode.security.generator.CredentialGenerator;
import org.apache.geode.security.templates.DummyAuthenticator;
import org.apache.geode.security.templates.UserPasswordAuthInit;

public class DummyCredentialGenerator
extends CredentialGenerator {
    @Override
    protected Properties initialize() throws IllegalArgumentException {
        return null;
    }

    @Override
    public CredentialGenerator.ClassCode classCode() {
        return CredentialGenerator.ClassCode.DUMMY;
    }

    @Override
    public String getAuthInit() {
        return UserPasswordAuthInit.class.getName() + ".create";
    }

    @Override
    public String getAuthenticator() {
        return DummyAuthenticator.class.getName() + ".create";
    }

    @Override
    public Properties getValidCredentials(int index) {
        String[] validGroups = new String[]{"admin", "user", "reader", "writer"};
        String[] admins = new String[]{"root", "admin", "administrator"};
        Properties props = new Properties();
        int groupNum = index % validGroups.length;
        String userName = groupNum == 0 ? admins[index % admins.length] : validGroups[groupNum] + index / validGroups.length;
        props.setProperty("security-username", userName);
        props.setProperty("security-password", userName);
        return props;
    }

    @Override
    public Properties getValidCredentials(Principal principal) {
        String userName = principal.getName();
        if (DummyAuthenticator.checkValidName(userName)) {
            Properties props = new Properties();
            props.setProperty("security-username", userName);
            props.setProperty("security-password", userName);
            return props;
        }
        throw new IllegalArgumentException("Dummy: [" + userName + "] is not a valid user");
    }

    @Override
    public Properties getInvalidCredentials(int index) {
        Properties props = new Properties();
        props.setProperty("security-username", "invalid" + index);
        props.setProperty("security-password", "none");
        return props;
    }
}

