/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.greplogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Patterns {
    IGNORED_EXCEPTION(Pattern.compile("<ExpectedException action=(add|remove)>(.*)</ExpectedException>")),
    LOG_STATEMENT(Pattern.compile("^\\[(?:fatal|error|warn|info|debug|trace|severe|warning|fine|finer|finest)")),
    BLANK(Pattern.compile("^\\s*$")),
    WARN_OR_LESS_LOG_LEVEL(Pattern.compile("^\\[(?:warn|warning|info|debug|trace|fine|finer|finest)")),
    ERROR_OR_MORE_LOG_LEVEL(Pattern.compile("^\\[(?:fatal|error|severe)")),
    CAUSED_BY(Pattern.compile("Caused by")),
    ERROR_SHORT_NAME(Pattern.compile("^\\[[^\\]]+\\](.*)$", 40)),
    DEBUG_WROTE_EXCEPTION(Pattern.compile("\\[debug.*Wrote exception:")),
    RMI_WARNING(Pattern.compile("^WARNING: Failed to .*java.rmi.ConnectException: Connection refused to host: .*; nested exception is:")),
    JAVA_LANG_ERROR(Pattern.compile("^java\\.lang\\.\\S+Error$")),
    EXCEPTION(Pattern.compile("Exception:")),
    EXCEPTION_2(Pattern.compile("( [\\w\\.]+Exception: (([\\S]+ ){0,6}))")),
    EXCEPTION_3(Pattern.compile("( [\\w\\.]+Exception)$")),
    EXCEPTION_4(Pattern.compile("^([^:]+: (([\\w\"]+ ){0,6}))")),
    MALFORMED_I18N_MESSAGE(Pattern.compile("[^\\d]\\{\\d+\\}")),
    RVV_BIT_SET_MESSAGE(Pattern.compile("RegionVersionVector.+bsv\\d+.+bs=\\{\\d+\\}")),
    MALFORMED_LOG4J_MESSAGE(Pattern.compile("\\{\\}")),
    HYDRA_MASTER_LOCATORS_WILDCARD(Pattern.compile("hydra\\.MasterDescription\\.master\\.locators=\\{\\}"));

    private final Pattern pattern;

    private Patterns(Pattern pattern) {
        this.pattern = pattern;
    }

    Matcher matcher(CharSequence input) {
        return this.pattern.matcher(input);
    }
}

