/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.Serializable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.VMEventListener;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.rules.RemoteInvoker;
import org.apache.geode.test.junit.rules.UseJacksonForJsonPathRule;
import org.apache.geode.test.junit.rules.serializable.SerializableTestRule;

public class DistributedUseJacksonForJsonPathRule
extends UseJacksonForJsonPathRule
implements SerializableTestRule {
    private static volatile UseJacksonForJsonPathRule instance = new UseJacksonForJsonPathRule();
    private final int vmCount;
    private final RemoteInvoker invoker;
    private final VMEventListener vmEventListener;

    public DistributedUseJacksonForJsonPathRule() {
        this(VM.DEFAULT_VM_COUNT, new RemoteInvoker());
    }

    public DistributedUseJacksonForJsonPathRule(int vmCount) {
        this(vmCount, new RemoteInvoker());
    }

    private DistributedUseJacksonForJsonPathRule(int vmCount, RemoteInvoker invoker) {
        this.vmCount = vmCount;
        this.invoker = invoker;
        this.vmEventListener = new InternalVMEventListener();
    }

    public void before() {
        DUnitLauncher.launchIfNeeded(this.vmCount);
        VM.addVMEventListener(this.vmEventListener);
        this.invoker.invokeInEveryVMAndController(() -> this.doBefore());
    }

    public void after() {
        VM.removeVMEventListener(this.vmEventListener);
        this.invoker.invokeInEveryVMAndController(() -> this.doAfter());
    }

    private void afterCreateVM(VM vm) {
        vm.invoke(() -> this.doBefore());
    }

    private void afterBounceVM(VM vm) {
        vm.invoke(() -> this.doBefore());
    }

    private void doBefore() {
        instance = new UseJacksonForJsonPathRule();
        instance.before();
    }

    private void doAfter() {
        instance.after();
        instance = null;
    }

    private class InternalVMEventListener
    implements VMEventListener,
    Serializable {
        private InternalVMEventListener() {
        }

        @Override
        public void afterCreateVM(VM vm) {
            DistributedUseJacksonForJsonPathRule.this.afterCreateVM(vm);
        }

        @Override
        public void afterBounceVM(VM vm) {
            DistributedUseJacksonForJsonPathRule.this.afterBounceVM(vm);
        }
    }
}

