/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.SerializableRunnable;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.VM;
import org.apache.logging.log4j.Logger;

public class IgnoredException
implements Serializable,
AutoCloseable {
    private static final Logger logger = LogService.getLogger();
    private static final ConcurrentLinkedQueue<IgnoredException> IGNORED_EXCEPTIONS = new ConcurrentLinkedQueue();
    private final String suspectString;
    private final transient VM vm;

    public static IgnoredException addIgnoredException(String suspectString) {
        return IgnoredException.addIgnoredException(suspectString, null);
    }

    public static IgnoredException addIgnoredException(Class exceptionClass) {
        return IgnoredException.addIgnoredException(exceptionClass.getName(), null);
    }

    public static IgnoredException addIgnoredException(String suspectString, VM vm) {
        IgnoredException ignoredException = new IgnoredException(suspectString, vm);
        SerializableRunnableIF addRunnable = IgnoredException.runnableForAdd(ignoredException.getAddMessage());
        try {
            addRunnable.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (vm != null) {
            vm.invoke(addRunnable);
        } else {
            Invoke.invokeInEveryVM(addRunnable);
        }
        IGNORED_EXCEPTIONS.add(ignoredException);
        return ignoredException;
    }

    public static void removeAllExpectedExceptions() {
        IgnoredException ignoredException;
        while ((ignoredException = IGNORED_EXCEPTIONS.poll()) != null) {
            ignoredException.remove();
        }
    }

    public IgnoredException(String suspectString) {
        this.suspectString = suspectString;
        this.vm = null;
    }

    IgnoredException(String suspectString, VM vm) {
        this.suspectString = suspectString;
        this.vm = vm;
    }

    public String getRemoveMessage() {
        return "<ExpectedException action=remove>" + this.suspectString + "</ExpectedException>";
    }

    public String getAddMessage() {
        return "<ExpectedException action=add>" + this.suspectString + "</ExpectedException>";
    }

    public void remove() {
        SerializableRunnableIF removeRunnable = IgnoredException.runnableForRemove(this.getRemoveMessage());
        try {
            removeRunnable.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.vm != null) {
            this.vm.invoke(removeRunnable);
        } else {
            Invoke.invokeInEveryVM(removeRunnable);
        }
    }

    @Override
    public void close() {
        this.remove();
    }

    String suspectString() {
        return this.suspectString;
    }

    VM vm() {
        return this.vm;
    }

    private static SerializableRunnableIF runnableForAdd(String message) {
        return IgnoredException.createRunnable(message, "addIgnoredException");
    }

    private static SerializableRunnableIF runnableForRemove(String message) {
        return IgnoredException.createRunnable(message, "remove");
    }

    private static SerializableRunnableIF createRunnable(final String message, String action) {
        return new SerializableRunnable(IgnoredException.class.getSimpleName() + " " + action){

            @Override
            public void run() {
                logger.info(message);
            }
        };
    }
}

