/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;
import org.junit.rules.TemporaryFolder;

public class LocatorLauncherStartupRule
extends SerializableExternalResource {
    private LocatorLauncher launcher;
    private final TemporaryFolder temp = new TemporaryFolder();
    private final Properties properties = new Properties();
    private boolean autoStart;

    public LocatorLauncherStartupRule withAutoStart() {
        this.autoStart = true;
        return this;
    }

    public LocatorLauncherStartupRule withProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public LocatorLauncherStartupRule withProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public void before() {
        LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setPort(Integer.valueOf(0)).set(this.properties).setMemberName("locator-0").set("log-level", "config");
        try {
            this.temp.create();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        builder.setWorkingDirectory(this.temp.getRoot().getAbsolutePath());
        this.launcher = builder.build();
        if (this.autoStart) {
            this.start();
        }
    }

    public void start() {
        this.launcher.start();
    }

    public void after() {
        if (this.launcher != null) {
            this.launcher.stop();
        }
        this.temp.delete();
    }
}

