/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Properties;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.generator.CredentialGenerator;
import org.apache.logging.log4j.Logger;

public class SSLCredentialGenerator
extends CredentialGenerator {
    private static final Logger logger = LogService.getLogger();

    @Override
    protected Properties initialize() throws IllegalArgumentException {
        this.javaProperties = this.getValidJavaSSLProperties();
        return this.getSSLProperties();
    }

    @Override
    public CredentialGenerator.ClassCode classCode() {
        return CredentialGenerator.ClassCode.SSL;
    }

    @Override
    public String getAuthInit() {
        return null;
    }

    @Override
    public String getAuthenticator() {
        return null;
    }

    @Override
    public Properties getValidCredentials(int index) {
        this.javaProperties = this.getValidJavaSSLProperties();
        return this.getSSLProperties();
    }

    @Override
    public Properties getValidCredentials(Principal principal) {
        this.javaProperties = this.getValidJavaSSLProperties();
        return this.getSSLProperties();
    }

    @Override
    public Properties getInvalidCredentials(int index) {
        this.javaProperties = this.getInvalidJavaSSLProperties();
        return this.getSSLProperties();
    }

    private File findTrustedJKS() {
        File ssldir = new File(System.getProperty("JTESTS") + "/ssl");
        return new File(ssldir, "trusted.keystore");
    }

    private File findUntrustedJKS() {
        File ssldir = new File(System.getProperty("JTESTS") + "/ssl");
        return new File(ssldir, "untrusted.keystore");
    }

    private Properties getValidJavaSSLProperties() {
        File jks = this.findTrustedJKS();
        try {
            Properties props = new Properties();
            props.setProperty("javax.net.ssl.trustStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.trustStorePassword", "password");
            props.setProperty("javax.net.ssl.keyStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.keyStorePassword", "password");
            return props;
        }
        catch (IOException ex) {
            throw new AuthenticationFailedException("SSL: Exception while opening the key store: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private Properties getInvalidJavaSSLProperties() {
        File jks = this.findUntrustedJKS();
        try {
            Properties props = new Properties();
            props.setProperty("javax.net.ssl.trustStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.trustStorePassword", "password");
            props.setProperty("javax.net.ssl.keyStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.keyStorePassword", "password");
            return props;
        }
        catch (IOException ex) {
            throw new AuthenticationFailedException("SSL: Exception while opening the key store: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private Properties getSSLProperties() {
        Properties props = new Properties();
        props.setProperty("cluster-ssl-ciphers", "true");
        props.setProperty("cluster-ssl-require-authentication", "true");
        props.setProperty("cluster-ssl-ciphers", "SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        props.setProperty("cluster-ssl-protocols", "TLSv1");
        return props;
    }
}

