/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.command;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.operations.ExecuteCQOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.cq.internal.CqServiceImpl;
import org.apache.geode.cache.query.cq.internal.ServerCQImpl;
import org.apache.geode.cache.query.cq.internal.command.BaseCQCommand;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqServiceProvider;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ExecuteCQ61
extends BaseCQCommand {
    protected static final Logger logger = LogService.getLogger();
    private static final ExecuteCQ61 singleton = new ExecuteCQ61();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteCQ61() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, InterruptedException {
        ServerCQImpl cqQuery;
        CqServiceImpl cqServiceForExec;
        Set cqRegionNames;
        Query query;
        CacheClientProxy proxy;
        CacheClientNotifier ccn;
        Acceptor acceptor = serverConnection.getAcceptor();
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        ClientProxyMembershipID id = serverConnection.getProxyID();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        String cqName = clientMessage.getPart(0).getString();
        String cqQueryString = clientMessage.getPart(1).getString();
        int cqState = clientMessage.getPart(2).getInt();
        Part isDurablePart = clientMessage.getPart(3);
        byte[] isDurableByte = isDurablePart.getSerializedForm();
        boolean isDurable = isDurableByte != null && isDurableByte[0] != 0;
        Part regionDataPolicyPart = clientMessage.getPart(clientMessage.getNumberOfParts() - 1);
        byte[] regionDataPolicyPartBytes = regionDataPolicyPart.getSerializedForm();
        DataPolicy regionDataPolicy = DataPolicy.fromOrdinal((byte)regionDataPolicyPartBytes[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {} CqName: {} queryString: {}", (Object)serverConnection.getName(), (Object)clientMessage.getMessageType(), (Object)serverConnection.getSocketString(), (Object)cqName, (Object)cqQueryString);
        }
        if ((ccn = acceptor.getCacheClientNotifier()) != null && (proxy = ccn.getClientProxy(id)) != null && !proxy.isNotifyBySubscription()) {
            String err = "Server notifyBySubscription mode is set to false. CQ execution is not supported in this mode.";
            this.sendCqResponse(MessageType.CQDATAERROR, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        ExecuteCQOperationContext executeCQContext = null;
        try {
            String newCqQueryString;
            DefaultQueryService qService = (DefaultQueryService)crHelper.getCache().getLocalQueryService();
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            query = qService.newQuery(cqQueryString);
            cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            if (authzRequest != null && !cqQueryString.equals(newCqQueryString = (executeCQContext = authzRequest.executeCQAuthorize(cqName, cqQueryString, cqRegionNames)).getQuery())) {
                query = qService.newQuery(newCqQueryString);
                cqQueryString = newCqQueryString;
                cqRegionNames = (Set)UncheckedUtils.uncheckedCast((Object)executeCQContext.getRegionNames());
                if (cqRegionNames == null) {
                    cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                }
            }
            ((DefaultQuery)query).getRegionsInQuery(null).forEach(regionName -> securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName));
            cqServiceForExec = (CqServiceImpl)qService.getCqService();
            serverConnection.setCq(cqName, isDurable);
            cqQuery = (ServerCQImpl)cqServiceForExec.executeCq(cqName, cqQueryString, cqState, id, ccn, isDurable, true, regionDataPolicy, Collections.emptyMap());
        }
        catch (CqException cqe) {
            this.sendCqResponse(MessageType.CQ_EXCEPTION_TYPE, "", clientMessage.getTransactionId(), cqe, serverConnection);
            serverConnection.removeCq(cqName, isDurable);
            return;
        }
        catch (Exception e) {
            ExecuteCQ61.writeChunkedException((Message)clientMessage, (Throwable)e, (ServerConnection)serverConnection);
            serverConnection.removeCq(cqName, isDurable);
            return;
        }
        boolean sendResults = clientMessage.getMessageType() == MessageType.EXECUTECQ_WITH_IR;
        boolean successQuery = false;
        if (sendResults || CqServiceImpl.EXECUTE_QUERY_DURING_INIT && CqServiceProvider.MAINTAIN_KEYS && !cqQuery.isPR()) {
            try {
                ((DefaultQuery)query).setIsCqQuery(true);
                successQuery = this.processQuery(clientMessage, query, cqQueryString, cqRegionNames, start, cqQuery, (QueryOperationContext)executeCQContext, serverConnection, sendResults, securityService);
                cqQuery.getVsdStats().setCqInitialResultsTime(DistributionStats.getStatTime() - start);
                stats.incProcessExecuteCqWithIRTime(DistributionStats.getStatTime() - start);
            }
            finally {
                if (!successQuery) {
                    try {
                        cqServiceForExec.closeCq(cqName, id);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        cqQuery.setCqResultsCacheInitialized();
        successQuery = true;
        if (!sendResults && successQuery) {
            this.sendCqResponse(MessageType.REPLY, "cq created successfully.", clientMessage.getTransactionId(), null, serverConnection);
            long start2 = DistributionStats.getStatTime();
            stats.incProcessCreateCqTime(start2 - start);
        }
        serverConnection.setAsTrue(1);
    }
}

