/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.operations.ExecuteCQOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.logging.log4j.Logger;

public class ExecuteCQ
extends BaseCQCommand {
    protected static final Logger logger = LogService.getLogger();
    private static final ExecuteCQ singleton = new ExecuteCQ();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteCQ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        boolean isDurable;
        AcceptorImpl acceptor = serverConnection.getAcceptor();
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        ClientProxyMembershipID id = serverConnection.getProxyID();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        String cqName = clientMessage.getPart(0).getString();
        String cqQueryString = clientMessage.getPart(1).getString();
        int cqState = clientMessage.getPart(2).getInt();
        Part isDurablePart = clientMessage.getPart(3);
        byte[] isDurableByte = isDurablePart.getSerializedForm();
        boolean bl = isDurable = isDurableByte != null && isDurableByte[0] != 0;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {} CqName: {} queryString: {}", (Object)serverConnection.getName(), (Object)MessageType.getString((int)clientMessage.getMessageType()), (Object)serverConnection.getSocketString(), (Object)cqName, (Object)cqQueryString);
        }
        DefaultQueryService qService = null;
        CqService cqServiceForExec = null;
        Query query = null;
        Set cqRegionNames = null;
        ExecuteCQOperationContext executeCQContext = null;
        ServerCQ cqQuery = null;
        try {
            String newCqQueryString;
            qService = (DefaultQueryService)crHelper.getCache().getLocalQueryService();
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null && !cqQueryString.equals(newCqQueryString = (executeCQContext = authzRequest.executeCQAuthorize(cqName, cqQueryString, cqRegionNames = ((DefaultQuery)(query = qService.newQuery(cqQueryString))).getRegionsInQuery(null))).getQuery())) {
                query = qService.newQuery(newCqQueryString);
                cqQueryString = newCqQueryString;
                cqRegionNames = executeCQContext.getRegionNames();
                if (cqRegionNames == null) {
                    cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                }
            }
            cqServiceForExec = qService.getCqService();
            cqQuery = cqServiceForExec.executeCq(cqName, cqQueryString, cqState, id, acceptor.getCacheClientNotifier(), isDurable, false, 0, null);
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
            return;
        }
        catch (Exception e) {
            ExecuteCQ.writeChunkedException((Message)clientMessage, (Throwable)e, (ServerConnection)serverConnection);
            return;
        }
        boolean sendResults = false;
        if (clientMessage.getMessageType() == 43) {
            sendResults = true;
        }
        boolean successQuery = false;
        try {
            if (query == null) {
                query = qService.newQuery(cqQueryString);
                cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            }
            ((DefaultQuery)query).setIsCqQuery(true);
            successQuery = this.processQuery(clientMessage, query, cqQueryString, cqRegionNames, start, cqQuery, (QueryOperationContext)executeCQContext, serverConnection, sendResults, securityService);
            cqQuery.getVsdStats().setCqInitialResultsTime(DistributionStats.getStatTime() - start);
            stats.incProcessExecuteCqWithIRTime(DistributionStats.getStatTime() - start);
        }
        finally {
            if (!successQuery) {
                try {
                    cqServiceForExec.closeCq(cqName, id);
                }
                catch (Exception exception) {}
            }
        }
        if (!sendResults && successQuery) {
            this.sendCqResponse(6, LocalizedStrings.ExecuteCQ_CQ_CREATED_SUCCESSFULLY.toLocalizedString(), clientMessage.getTransactionId(), null, serverConnection);
            long start2 = DistributionStats.getStatTime();
            stats.incProcessCreateCqTime(start2 - start);
        }
        serverConnection.setAsTrue(1);
    }
}

