/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.operations.ExecuteCQOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqServiceImpl;
import org.apache.geode.cache.query.internal.cq.CqServiceProvider;
import org.apache.geode.cache.query.internal.cq.ServerCQImpl;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.cache.vmotion.VMotionObserver;
import org.apache.geode.internal.cache.vmotion.VMotionObserverHolder;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.logging.log4j.Logger;

public class ExecuteCQ61
extends BaseCQCommand {
    protected static final Logger logger = LogService.getLogger();
    private static final ExecuteCQ61 singleton = new ExecuteCQ61();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteCQ61() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, InterruptedException {
        CacheClientProxy proxy;
        CacheClientNotifier ccn;
        AcceptorImpl acceptor = serverConnection.getAcceptor();
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        ClientProxyMembershipID id = serverConnection.getProxyID();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        String cqName = clientMessage.getPart(0).getString();
        String cqQueryString = clientMessage.getPart(1).getString();
        int cqState = clientMessage.getPart(2).getInt();
        Part isDurablePart = clientMessage.getPart(3);
        byte[] isDurableByte = isDurablePart.getSerializedForm();
        boolean isDurable = isDurableByte != null && isDurableByte[0] != 0;
        Part regionDataPolicyPart = clientMessage.getPart(clientMessage.getNumberOfParts() - 1);
        byte[] regionDataPolicyPartBytes = regionDataPolicyPart.getSerializedForm();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {} CqName: {} queryString: {}", (Object)serverConnection.getName(), (Object)MessageType.getString((int)clientMessage.getMessageType()), (Object)serverConnection.getSocketString(), (Object)cqName, (Object)cqQueryString);
        }
        if ((ccn = acceptor.getCacheClientNotifier()) != null && (proxy = ccn.getClientProxy(id)) != null && !proxy.isNotifyBySubscription()) {
            String err = LocalizedStrings.ExecuteCQ_SERVER_NOTIFYBYSUBSCRIPTION_MODE_IS_SET_TO_FALSE_CQ_EXECUTION_IS_NOT_SUPPORTED_IN_THIS_MODE.toLocalizedString();
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        DefaultQueryService qService = null;
        CqServiceImpl cqServiceForExec = null;
        Query query = null;
        Set cqRegionNames = null;
        ExecuteCQOperationContext executeCQContext = null;
        ServerCQImpl cqQuery = null;
        try {
            String newCqQueryString;
            qService = (DefaultQueryService)crHelper.getCache().getLocalQueryService();
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null && !cqQueryString.equals(newCqQueryString = (executeCQContext = authzRequest.executeCQAuthorize(cqName, cqQueryString, cqRegionNames = ((DefaultQuery)(query = qService.newQuery(cqQueryString))).getRegionsInQuery(null))).getQuery())) {
                query = qService.newQuery(newCqQueryString);
                cqQueryString = newCqQueryString;
                cqRegionNames = executeCQContext.getRegionNames();
                if (cqRegionNames == null) {
                    cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                }
            }
            if (CqServiceProvider.VMOTION_DURING_CQ_REGISTRATION_FLAG) {
                VMotionObserver vmo = VMotionObserverHolder.getInstance();
                vmo.vMotionBeforeCQRegistration();
            }
            cqServiceForExec = (CqServiceImpl)qService.getCqService();
            serverConnection.setCq(cqName, isDurable);
            cqQuery = (ServerCQImpl)cqServiceForExec.executeCq(cqName, cqQueryString, cqState, id, ccn, isDurable, true, regionDataPolicyPartBytes[0], null);
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
            serverConnection.removeCq(cqName, isDurable);
            return;
        }
        catch (Exception e) {
            ExecuteCQ61.writeChunkedException((Message)clientMessage, (Throwable)e, (ServerConnection)serverConnection);
            serverConnection.removeCq(cqName, isDurable);
            return;
        }
        long oldstart = start;
        boolean sendResults = false;
        boolean successQuery = false;
        if (clientMessage.getMessageType() == 43) {
            sendResults = true;
        }
        if (sendResults || CqServiceImpl.EXECUTE_QUERY_DURING_INIT && CqServiceProvider.MAINTAIN_KEYS && !cqQuery.isPR()) {
            try {
                if (query == null) {
                    query = qService.newQuery(cqQueryString);
                    cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                }
                ((DefaultQuery)query).setIsCqQuery(true);
                successQuery = this.processQuery(clientMessage, query, cqQueryString, cqRegionNames, start, cqQuery, (QueryOperationContext)executeCQContext, serverConnection, sendResults);
                cqQuery.getVsdStats().setCqInitialResultsTime(DistributionStats.getStatTime() - oldstart);
                stats.incProcessExecuteCqWithIRTime(DistributionStats.getStatTime() - oldstart);
            }
            finally {
                if (!successQuery) {
                    try {
                        cqServiceForExec.closeCq(cqName, id);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        cqQuery.cqResultKeysInitialized = true;
        successQuery = true;
        if (!sendResults && successQuery) {
            this.sendCqResponse(6, LocalizedStrings.ExecuteCQ_CQ_CREATED_SUCCESSFULLY.toLocalizedString(), clientMessage.getTransactionId(), null, serverConnection);
            long start2 = DistributionStats.getStatTime();
            stats.incProcessCreateCqTime(start2 - oldstart);
        }
        serverConnection.setAsTrue(1);
    }
}

