/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.security.AuthorizeRequest;

public class GetDurableCQs
extends BaseCQCommand {
    private static final GetDurableCQs singleton = new GetDurableCQs();

    public static Command getCommand() {
        return singleton;
    }

    private GetDurableCQs() {
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        AcceptorImpl acceptor = servConn.getAcceptor();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {}", (Object)servConn.getName(), (Object)MessageType.getString((int)msg.getMessageType()), (Object)servConn.getSocketString());
        }
        DefaultQueryService qService = null;
        CqService cqServiceForExec = null;
        try {
            qService = (DefaultQueryService)((GemFireCacheImpl)crHelper.getCache()).getLocalQueryService();
            this.securityService.authorizeClusterRead();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                authzRequest.getDurableCQsAuthorize();
            }
            cqServiceForExec = qService.getCqService();
            List durableCqs = cqServiceForExec.getAllDurableClientCqs(id);
            ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
            chunkedResponseMsg.setMessageType(1);
            chunkedResponseMsg.setTransactionId(msg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            ArrayList durableCqList = new ArrayList(maximumChunkSize);
            boolean isTraceEnabled = logger.isTraceEnabled();
            for (Object durableCqName : durableCqs) {
                durableCqList.add(durableCqName);
                if (isTraceEnabled) {
                    logger.trace("{}: getDurableCqsResponse <{}>; list size was {}", (Object)servConn.getName(), durableCqName, (Object)durableCqList.size());
                }
                if (durableCqList.size() != maximumChunkSize) continue;
                this.sendDurableCqsResponseChunk(durableCqList, false, servConn);
                durableCqList.clear();
            }
            this.sendDurableCqsResponseChunk(durableCqList, true, servConn);
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", msg.getTransactionId(), cqe, servConn);
            return;
        }
        catch (Exception e) {
            GetDurableCQs.writeChunkedException((Message)msg, (Throwable)e, (boolean)false, (ServerConnection)servConn);
            return;
        }
    }

    private void sendDurableCqsResponseChunk(List list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart((Object)list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} durableCQs response chunk{}", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)(logger.isTraceEnabled() ? " keys=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""));
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

