/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.operations.ExecuteCQOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.logging.log4j.Logger;

public class ExecuteCQ
extends BaseCQCommand {
    protected static final Logger logger = LogService.getLogger();
    private static final ExecuteCQ singleton = new ExecuteCQ();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteCQ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        boolean isDurable;
        AcceptorImpl acceptor = servConn.getAcceptor();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        String cqName = msg.getPart(0).getString();
        String cqQueryString = msg.getPart(1).getString();
        int cqState = msg.getPart(2).getInt();
        Part isDurablePart = msg.getPart(3);
        byte[] isDurableByte = isDurablePart.getSerializedForm();
        boolean bl = isDurable = isDurableByte != null && isDurableByte[0] != 0;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {} CqName: {} queryString: {}", (Object)servConn.getName(), (Object)MessageType.getString((int)msg.getMessageType()), (Object)servConn.getSocketString(), (Object)cqName, (Object)cqQueryString);
        }
        DefaultQueryService qService = null;
        CqService cqServiceForExec = null;
        Query query = null;
        Set cqRegionNames = null;
        ExecuteCQOperationContext executeCQContext = null;
        ServerCQ cqQuery = null;
        try {
            String newCqQueryString;
            qService = (DefaultQueryService)((GemFireCacheImpl)crHelper.getCache()).getLocalQueryService();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null && !cqQueryString.equals(newCqQueryString = (executeCQContext = authzRequest.executeCQAuthorize(cqName, cqQueryString, cqRegionNames = ((DefaultQuery)(query = qService.newQuery(cqQueryString))).getRegionsInQuery(null))).getQuery())) {
                query = qService.newQuery(newCqQueryString);
                cqQueryString = newCqQueryString;
                cqRegionNames = executeCQContext.getRegionNames();
                if (cqRegionNames == null) {
                    cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                }
            }
            cqServiceForExec = qService.getCqService();
            cqQuery = cqServiceForExec.executeCq(cqName, cqQueryString, cqState, id, acceptor.getCacheClientNotifier(), isDurable, false, 0, null);
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", msg.getTransactionId(), cqe, servConn);
            return;
        }
        catch (Exception e) {
            ExecuteCQ.writeChunkedException((Message)msg, (Throwable)e, (boolean)false, (ServerConnection)servConn);
            return;
        }
        long oldstart = start;
        boolean sendResults = false;
        boolean successQuery = false;
        if (msg.getMessageType() == 43) {
            sendResults = true;
        }
        try {
            if (query == null) {
                query = qService.newQuery(cqQueryString);
                cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            }
            ((DefaultQuery)query).setIsCqQuery(true);
            successQuery = this.processQuery(msg, query, cqQueryString, cqRegionNames, start, cqQuery, (QueryOperationContext)executeCQContext, servConn, sendResults);
            cqQuery.getVsdStats().setCqInitialResultsTime(DistributionStats.getStatTime() - oldstart);
            stats.incProcessExecuteCqWithIRTime(DistributionStats.getStatTime() - oldstart);
        }
        finally {
            if (!successQuery) {
                try {
                    cqServiceForExec.closeCq(cqName, id);
                }
                catch (Exception exception) {}
            }
        }
        if (!sendResults && successQuery) {
            this.sendCqResponse(6, LocalizedStrings.ExecuteCQ_CQ_CREATED_SUCCESSFULLY.toLocalizedString(), msg.getTransactionId(), null, servConn);
            long start2 = DistributionStats.getStatTime();
            stats.incProcessCreateCqTime(start2 - oldstart);
        }
        servConn.setAsTrue(1);
    }
}

