/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.cq;

import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqServiceStatistics;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqServiceImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;

public class CqServiceStatisticsImpl
implements CqServiceStatistics {
    private CqServiceImpl cqService;

    public CqServiceStatisticsImpl(CqServiceImpl cqs) {
        this.cqService = cqs;
    }

    public long numCqsActive() {
        return this.cqService.getCqServiceVsdStats().getNumCqsActive();
    }

    public long numCqsCreated() {
        return this.cqService.getCqServiceVsdStats().getNumCqsCreated();
    }

    public long numCqsClosed() {
        return this.cqService.getCqServiceVsdStats().getNumCqsClosed();
    }

    public long numCqsStopped() {
        return this.cqService.getCqServiceVsdStats().getNumCqsStopped();
    }

    public long numCqsOnClient() {
        return this.cqService.getCqServiceVsdStats().getNumCqsOnClient();
    }

    public long numCqsOnRegion(String regionName) {
        DefaultQueryService queryService = (DefaultQueryService)((GemFireCacheImpl)CacheFactory.getAnyInstance()).getLocalQueryService();
        try {
            CqQuery[] cqs = queryService.getCqs(regionName);
            if (cqs != null) {
                return cqs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }
}

