/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.operations.ExecuteCQOperationContext;
import com.gemstone.gemfire.cache.operations.QueryOperationContext;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.cache.query.internal.cq.ServerCQ;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.BaseCQCommand;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ExecuteCQ
extends BaseCQCommand {
    protected static final Logger logger = LogService.getLogger();
    private static final ExecuteCQ singleton = new ExecuteCQ();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteCQ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        boolean isDurable;
        AcceptorImpl acceptor = servConn.getAcceptor();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        String cqName = msg.getPart(0).getString();
        String cqQueryString = msg.getPart(1).getString();
        int cqState = msg.getPart(2).getInt();
        Part isDurablePart = msg.getPart(3);
        byte[] isDurableByte = isDurablePart.getSerializedForm();
        boolean bl = isDurable = isDurableByte != null && isDurableByte[0] != 0;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {} CqName: {} queryString: {}", (Object)servConn.getName(), (Object)MessageType.getString((int)msg.getMessageType()), (Object)servConn.getSocketString(), (Object)cqName, (Object)cqQueryString);
        }
        DefaultQueryService qService = null;
        CqService cqServiceForExec = null;
        Query query = null;
        Set cqRegionNames = null;
        ExecuteCQOperationContext executeCQContext = null;
        ServerCQ cqQuery = null;
        try {
            String newCqQueryString;
            qService = (DefaultQueryService)((GemFireCacheImpl)crHelper.getCache()).getLocalQueryService();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null && !cqQueryString.equals(newCqQueryString = (executeCQContext = authzRequest.executeCQAuthorize(cqName, cqQueryString, cqRegionNames = ((DefaultQuery)(query = qService.newQuery(cqQueryString))).getRegionsInQuery(null))).getQuery())) {
                query = qService.newQuery(newCqQueryString);
                cqQueryString = newCqQueryString;
                cqRegionNames = executeCQContext.getRegionNames();
                if (cqRegionNames == null) {
                    cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                }
            }
            cqServiceForExec = qService.getCqService();
            cqQuery = cqServiceForExec.executeCq(cqName, cqQueryString, cqState, id, acceptor.getCacheClientNotifier(), isDurable, false, 0, null);
        }
        catch (CqException cqe) {
            ExecuteCQ.sendCqResponse((int)50, (String)"", (int)msg.getTransactionId(), (Throwable)cqe, (ServerConnection)servConn);
            return;
        }
        catch (Exception e) {
            ExecuteCQ.writeChunkedException((Message)msg, (Throwable)e, (boolean)false, (ServerConnection)servConn);
            return;
        }
        long oldstart = start;
        boolean sendResults = false;
        boolean successQuery = false;
        if (msg.getMessageType() == 43) {
            sendResults = true;
        }
        try {
            if (query == null) {
                query = qService.newQuery(cqQueryString);
                cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            }
            ((DefaultQuery)query).setIsCqQuery(true);
            successQuery = ExecuteCQ.processQuery((Message)msg, (Query)query, (String)cqQueryString, (Set)cqRegionNames, (long)start, (ServerCQ)cqQuery, (QueryOperationContext)executeCQContext, (ServerConnection)servConn, (boolean)sendResults);
            cqQuery.getVsdStats().setCqInitialResultsTime(DistributionStats.getStatTime() - oldstart);
            stats.incProcessExecuteCqWithIRTime(DistributionStats.getStatTime() - oldstart);
        }
        finally {
            if (!successQuery) {
                try {
                    cqServiceForExec.closeCq(cqName, id);
                }
                catch (Exception exception) {}
            }
        }
        if (!sendResults && successQuery) {
            ExecuteCQ.sendCqResponse((int)6, (String)LocalizedStrings.ExecuteCQ_CQ_CREATED_SUCCESSFULLY.toLocalizedString(), (int)msg.getTransactionId(), null, (ServerConnection)servConn);
            long start2 = DistributionStats.getStatTime();
            stats.incProcessCreateCqTime(start2 - oldstart);
        }
        servConn.setAsTrue(1);
    }
}

