/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.cq;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.cq.CqServiceImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;

public class CqServiceStatisticsImpl
implements CqServiceStatistics {
    private CqServiceImpl cqService;

    public CqServiceStatisticsImpl(CqServiceImpl cqs) {
        this.cqService = cqs;
    }

    public long numCqsActive() {
        return this.cqService.getCqServiceVsdStats().getNumCqsActive();
    }

    public long numCqsCreated() {
        return this.cqService.getCqServiceVsdStats().getNumCqsCreated();
    }

    public long numCqsClosed() {
        return this.cqService.getCqServiceVsdStats().getNumCqsClosed();
    }

    public long numCqsStopped() {
        return this.cqService.getCqServiceVsdStats().getNumCqsStopped();
    }

    public long numCqsOnClient() {
        return this.cqService.getCqServiceVsdStats().getNumCqsOnClient();
    }

    public long numCqsOnRegion(String regionName) {
        DefaultQueryService queryService = (DefaultQueryService)((GemFireCacheImpl)CacheFactory.getAnyInstance()).getLocalQueryService();
        try {
            CqQuery[] cqs = queryService.getCqs(regionName);
            if (cqs != null) {
                return cqs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }
}

