/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.geode.SerializationException;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataManager;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.pdx.PdxWriter;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.pdx.internal.PdxOutputStream;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.pdx.internal.TypeRegistry;

@Experimental
public class CreateMappingPreconditionCheckFunction
extends CliFunction<Object[]> {
    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) {
        CliFunctionResult cliFunctionResult;
        block10: {
            Object[] args = (Object[])context.getArguments();
            RegionMapping regionMapping = (RegionMapping)((Object)args[0]);
            String remoteInputStreamName = (String)args[1];
            RemoteInputStream remoteInputStream = (RemoteInputStream)args[2];
            String dataSourceName = regionMapping.getDataSourceName();
            DataSource dataSource = this.getDataSource(dataSourceName);
            if (dataSource == null) {
                throw new JdbcConnectorException("JDBC data-source named \"" + dataSourceName + "\" not found. Create it with gfsh 'create data-source --pooled --name=" + dataSourceName + "'.");
            }
            InternalCache cache = (InternalCache)context.getCache();
            TypeRegistry typeRegistry = cache.getPdxRegistry();
            PdxType pdxType = this.getPdxTypeForClass(cache, typeRegistry, regionMapping.getPdxName(), remoteInputStreamName, remoteInputStream);
            Connection connection = dataSource.getConnection();
            try {
                TableMetaDataView tableMetaData = this.getTableMetaDataManager().getTableMetaDataView(connection, regionMapping);
                JdbcConnectorService service = (JdbcConnectorService)cache.getService(JdbcConnectorService.class);
                List<FieldMapping> fieldMappings = service.createFieldMappingUsingPdx(pdxType, tableMetaData);
                Object[] output = new Object[2];
                output[1] = fieldMappings;
                if (regionMapping.getIds() == null || regionMapping.getIds().isEmpty()) {
                    List<String> keyColumnNames = tableMetaData.getKeyColumnNames();
                    output[0] = String.join((CharSequence)",", keyColumnNames);
                }
                String member = context.getMemberName();
                cliFunctionResult = new CliFunctionResult(member, (Object)output);
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw JdbcConnectorException.createException(e);
                }
            }
            connection.close();
        }
        return cliFunctionResult;
    }

    private PdxType getPdxTypeForClass(InternalCache cache, TypeRegistry typeRegistry, String className, String remoteInputStreamName, RemoteInputStream remoteInputStream) {
        Class<?> clazz = this.loadPdxClass(className, remoteInputStreamName, remoteInputStream);
        PdxType result = typeRegistry.getExistingTypeForClass(clazz);
        if (result != null) {
            return result;
        }
        return this.generatePdxTypeForClass(cache, typeRegistry, clazz);
    }

    private PdxType generatePdxTypeForClass(InternalCache cache, TypeRegistry typeRegistry, Class<?> clazz) {
        block2: {
            Object object = this.createInstance(clazz);
            try {
                cache.registerPdxMetaData(object);
            }
            catch (SerializationException ex) {
                String className = clazz.getName();
                ReflectionBasedAutoSerializer serializer = this.getReflectionBasedAutoSerializer("\\Q" + className + "\\E");
                PdxWriter writer = this.createPdxWriter(typeRegistry, object);
                boolean result = serializer.toData(object, writer);
                if (result) break block2;
                throw new JdbcConnectorException("Could not generate a PdxType using the ReflectionBasedAutoSerializer for the class  " + clazz.getName() + " after failing to register pdx metadata due to " + ex.getMessage() + ". Check the server log for details.");
            }
        }
        return typeRegistry.getExistingTypeForClass(clazz);
    }

    private Object createInstance(Class<?> clazz) {
        try {
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new JdbcConnectorException("Could not generate a PdxType for the class " + clazz.getName() + " because it did not have a public zero arg constructor. Details: " + String.valueOf(ex));
        }
    }

    private Class<?> loadPdxClass(String className, String remoteInputStreamName, RemoteInputStream remoteInputStream) {
        try {
            if (remoteInputStream != null) {
                return this.loadPdxClassFromRemoteStream(className, remoteInputStreamName, remoteInputStream);
            }
            return this.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new JdbcConnectorException("The pdx class \"" + className + "\" could not be loaded because: " + String.valueOf(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadPdxClassFromRemoteStream(String className, String remoteInputStreamName, RemoteInputStream remoteInputStream) throws ClassNotFoundException {
        Path tempDir = this.createTemporaryDirectory("pdx-class-dir-");
        try {
            File file = this.copyRemoteInputStreamToTempFile(className, remoteInputStreamName, remoteInputStream, tempDir);
            Class<?> clazz = this.loadClass(className, this.createURL(file, tempDir));
            return clazz;
        }
        finally {
            this.deleteDirectory(tempDir);
        }
    }

    Path createTemporaryDirectory(String prefix) {
        try {
            return this.createTempDirectory(prefix);
        }
        catch (IOException ex) {
            throw new JdbcConnectorException("Could not create a temporary directory with the prefix \"" + prefix + "\" because: " + String.valueOf(ex));
        }
    }

    void deleteDirectory(Path tempDir) {
        try {
            FileUtils.deleteDirectory((File)tempDir.toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private URL createURL(File file, Path tempDir) {
        URI uri = this.isJar(file.getName()) ? file.toURI() : tempDir.toUri();
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new JdbcConnectorException("Could not convert \"" + String.valueOf(uri) + "\" to a URL, because: " + String.valueOf(e));
        }
    }

    private boolean isJar(String fileName) {
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        return fileExtension.equalsIgnoreCase("jar");
    }

    private File copyRemoteInputStreamToTempFile(String className, String remoteInputStreamName, RemoteInputStream remoteInputStream, Path tempDir) {
        if (!this.isJar(remoteInputStreamName) && className.contains(".")) {
            File packageDir = new File(tempDir.toFile(), className.replace(".", "/")).getParentFile();
            packageDir.mkdirs();
            tempDir = packageDir.toPath();
        }
        try {
            Path tempPdxClassFile = Paths.get(tempDir.toString(), remoteInputStreamName);
            try (InputStream input = RemoteInputStreamClient.wrap((RemoteInputStream)remoteInputStream);
                 FileOutputStream output = new FileOutputStream(tempPdxClassFile.toString());){
                this.copyFile(input, output);
            }
            return tempPdxClassFile.toFile();
        }
        catch (IOException iox) {
            throw new JdbcConnectorException("The pdx class file \"" + remoteInputStreamName + "\" could not be copied to a temporary file, because: " + String.valueOf(iox));
        }
    }

    DataSource getDataSource(String dataSourceName) {
        return JNDIInvoker.getDataSource((String)dataSourceName);
    }

    Class<?> loadClass(String className) throws ClassNotFoundException {
        return ClassPathLoader.getLatest().forName(className);
    }

    Class<?> loadClass(String className, URL url) throws ClassNotFoundException {
        return URLClassLoader.newInstance(new URL[]{url}).loadClass(className);
    }

    ReflectionBasedAutoSerializer getReflectionBasedAutoSerializer(String className) {
        return new ReflectionBasedAutoSerializer(new String[]{className});
    }

    PdxWriter createPdxWriter(TypeRegistry typeRegistry, Object object) {
        return new PdxWriterImpl(typeRegistry, object, new PdxOutputStream());
    }

    TableMetaDataManager getTableMetaDataManager() {
        return new TableMetaDataManager();
    }

    Path createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(prefix, new FileAttribute[0]);
    }

    void copyFile(InputStream input, FileOutputStream output) throws IOException {
        IOUtils.copyLarge((InputStream)input, (OutputStream)output);
    }
}

