/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.geode.datasource.PooledDataSourceFactory;

public class JdbcPooledDataSourceFactory
implements PooledDataSourceFactory {
    public DataSource createDataSource(Properties poolProperties, Properties dataSourceProperties) {
        Properties hikariProperties = this.convertToHikari(poolProperties);
        HikariConfig config = new HikariConfig(hikariProperties);
        config.setDataSourceProperties(dataSourceProperties);
        return new HikariDataSource(config);
    }

    Properties convertToHikari(Properties poolProperties) {
        int MILLIS_PER_SECOND = 1000;
        Properties result = new Properties();
        String jdbcUrl = null;
        for (String name : poolProperties.stringPropertyNames()) {
            String hikariName = this.convertToCamelCase(name);
            String hikariValue = poolProperties.getProperty(name);
            if (name.equals("connection-url")) {
                hikariName = "jdbcUrl";
                jdbcUrl = hikariValue;
            } else if (name.equals("jdbc-driver-class")) {
                hikariName = "driverClassName";
            } else if (name.equals("user-name")) {
                hikariName = "username";
            } else if (name.equals("max-pool-size")) {
                hikariName = "maximumPoolSize";
            } else if (name.equals("idle-timeout-seconds")) {
                hikariName = "idleTimeout";
                hikariValue = String.valueOf(Integer.parseInt(hikariValue) * 1000);
            }
            result.setProperty(hikariName, hikariValue);
        }
        if (jdbcUrl != null && jdbcUrl.contains("?")) {
            Map<String, String> urlParams = this.parseUrlParameters(jdbcUrl);
            if (!result.containsKey("username") && urlParams.containsKey("user")) {
                String userFromUrl = urlParams.get("user");
                result.setProperty("username", userFromUrl);
            }
            if (!result.containsKey("password") && urlParams.containsKey("password")) {
                String passwordFromUrl = urlParams.get("password");
                result.setProperty("password", passwordFromUrl);
            }
            String cleanUrl = this.stripCredentialsFromUrl(jdbcUrl);
            result.setProperty("jdbcUrl", cleanUrl);
        }
        return result;
    }

    Map<String, String> parseUrlParameters(String jdbcUrl) {
        String[] pairs;
        HashMap<String, String> params = new HashMap<String, String>();
        if (jdbcUrl == null || !jdbcUrl.contains("?")) {
            return params;
        }
        String queryString = jdbcUrl.substring(jdbcUrl.indexOf(63) + 1);
        for (String pair : pairs = queryString.split("&")) {
            int idx = pair.indexOf(61);
            if (idx <= 0 || idx >= pair.length() - 1) continue;
            String key = pair.substring(0, idx);
            String value = pair.substring(idx + 1);
            params.put(key, value);
        }
        return params;
    }

    String stripCredentialsFromUrl(String jdbcUrl) {
        String[] pairs;
        if (jdbcUrl == null || !jdbcUrl.contains("?")) {
            return jdbcUrl;
        }
        String baseUrl = jdbcUrl.substring(0, jdbcUrl.indexOf(63));
        String queryString = jdbcUrl.substring(jdbcUrl.indexOf(63) + 1);
        StringBuilder cleanParams = new StringBuilder();
        for (String pair : pairs = queryString.split("&")) {
            String key;
            int idx = pair.indexOf(61);
            if (idx <= 0 || (key = pair.substring(0, idx)).equals("user") || key.equals("password")) continue;
            if (cleanParams.length() > 0) {
                cleanParams.append("&");
            }
            cleanParams.append(pair);
        }
        if (cleanParams.length() > 0) {
            return baseUrl + "?" + cleanParams.toString();
        }
        return baseUrl;
    }

    private String convertToCamelCase(String name) {
        StringBuilder nameBuilder = new StringBuilder(name.length());
        boolean capitalizeNextChar = false;
        for (char c : name.toCharArray()) {
            if (c == '-') {
                capitalizeNextChar = true;
                continue;
            }
            if (capitalizeNextChar) {
                nameBuilder.append(Character.toUpperCase(c));
            } else {
                nameBuilder.append(c);
            }
            capitalizeNextChar = false;
        }
        return nameBuilder.toString();
    }
}

