/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.internal.InternalAsyncEventQueue;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.JdbcLoader;
import org.apache.geode.connectors.jdbc.JdbcWriter;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.connectors.util.internal.MappingCommandUtils;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class DestroyMappingFunction
extends CliFunction<String> {
    public CliFunctionResult executeFunction(FunctionContext<String> context) {
        Cache cache = context.getCache();
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        String regionName = (String)context.getArguments();
        String member = context.getMemberName();
        RegionMapping mapping = service.getMappingForRegion(regionName);
        if (mapping != null) {
            this.cleanupRegionAndQueue(cache, regionName);
            service.destroyRegionMapping(regionName);
            String message = "Destroyed JDBC mapping for region " + regionName + " on " + member;
            return new CliFunctionResult(member, CliFunctionResult.StatusState.OK, message);
        }
        String message = "JDBC mapping for region \"" + regionName + "\" not found";
        return new CliFunctionResult(member, CliFunctionResult.StatusState.ERROR, message);
    }

    private void cleanupRegionAndQueue(Cache cache, String regionName) {
        InternalAsyncEventQueue queue;
        String queueName = MappingCommandUtils.createAsyncEventQueueName(regionName);
        Region region = cache.getRegion(regionName);
        if (region != null) {
            Set queueIds;
            CacheWriter writer;
            CacheLoader loader = region.getAttributes().getCacheLoader();
            if (loader instanceof JdbcLoader) {
                region.getAttributesMutator().setCacheLoader(null);
            }
            if ((writer = region.getAttributes().getCacheWriter()) instanceof JdbcWriter) {
                region.getAttributesMutator().setCacheWriter(null);
            }
            if ((queueIds = region.getAttributes().getAsyncEventQueueIds()).contains(queueName)) {
                region.getAttributesMutator().removeAsyncEventQueueId(queueName);
            }
        }
        if ((queue = (InternalAsyncEventQueue)cache.getAsyncEventQueue(queueName)) != null) {
            queue.stop();
            queue.destroy();
        }
    }
}

