/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.JdbcAsyncWriter;
import org.apache.geode.connectors.jdbc.JdbcLoader;
import org.apache.geode.connectors.jdbc.JdbcWriter;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.connectors.util.internal.MappingCommandUtils;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class CreateMappingFunction
extends CliFunction<Object[]> {
    CreateMappingFunction() {
    }

    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) throws Exception {
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        Object[] arguments = (Object[])context.getArguments();
        RegionMapping regionMapping = (RegionMapping)arguments[0];
        boolean synchronous = (Boolean)arguments[1];
        String regionName = regionMapping.getRegionName();
        Region<?, ?> region = this.verifyRegionExists(context.getCache(), regionName);
        String queueName = MappingCommandUtils.createAsyncEventQueueName(regionName);
        if (!synchronous) {
            this.createAsyncEventQueue(context.getCache(), queueName, region.getAttributes().getDataPolicy().withPartitioning());
        }
        this.alterRegion(region, queueName, synchronous);
        this.createRegionMapping(service, regionMapping);
        String member = context.getMemberName();
        String message = "Created JDBC mapping for region " + regionMapping.getRegionName() + " on " + member;
        return new CliFunctionResult(member, true, message);
    }

    private void alterRegion(Region<?, ?> region, String queueName, boolean synchronous) {
        region.getAttributesMutator().setCacheLoader(new JdbcLoader());
        if (synchronous) {
            region.getAttributesMutator().setCacheWriter(new JdbcWriter());
        } else {
            region.getAttributesMutator().addAsyncEventQueueId(queueName);
        }
    }

    private void createAsyncEventQueue(Cache cache, String queueName, boolean isPartitioned) {
        AsyncEventQueueFactory asyncEventQueueFactory = cache.createAsyncEventQueueFactory();
        asyncEventQueueFactory.setParallel(isPartitioned);
        asyncEventQueueFactory.create(queueName, (AsyncEventListener)new JdbcAsyncWriter());
    }

    private Region<?, ?> verifyRegionExists(Cache cache, String regionName) {
        Region result = cache.getRegion(regionName);
        if (result == null) {
            throw new IllegalStateException("create jdbc-mapping requires that the region \"" + regionName + "\" exists.");
        }
        return result;
    }

    void createRegionMapping(JdbcConnectorService service, RegionMapping regionMapping) throws RegionMappingExistsException {
        service.createRegionMapping(regionMapping);
    }
}

