/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.configuration;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.XSDRootElement;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

@Experimental
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="mapping", namespace="http://geode.apache.org/schema/jdbc")
@XSDRootElement(namespace="http://geode.apache.org/schema/jdbc", schemaLocation="http://geode.apache.org/schema/jdbc/jdbc-1.0.xsd")
public class RegionMapping
implements CacheElement {
    private static final String MAPPINGS_DELIMITER = ":";
    @XmlAttribute(name="connection-name")
    protected String connectionConfigName;
    @XmlAttribute(name="table")
    protected String tableName;
    @XmlAttribute(name="pdx-name")
    protected String pdxName;
    @XmlTransient
    protected String regionName;
    public static final String ELEMENT_ID = "jdbc-mapping";

    public RegionMapping() {
    }

    public RegionMapping(String regionName, String pdxName, String tableName, String connectionConfigName) {
        this.regionName = regionName;
        this.pdxName = pdxName;
        this.tableName = tableName;
        this.connectionConfigName = connectionConfigName;
    }

    public void setConnectionConfigName(String connectionConfigName) {
        this.connectionConfigName = connectionConfigName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPdxName(String pdxName) {
        this.pdxName = pdxName;
    }

    public String getConnectionConfigName() {
        return this.connectionConfigName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getPdxName() {
        return this.pdxName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getRegionToTableName() {
        if (this.tableName == null) {
            return this.regionName;
        }
        return this.tableName;
    }

    public String getColumnNameForField(String fieldName, TableMetaDataView tableMetaDataView) {
        Set<String> columnNames = tableMetaDataView.getColumnNames();
        if (columnNames.contains(fieldName)) {
            return fieldName;
        }
        List ignoreCaseMatch = columnNames.stream().filter(c -> c.equalsIgnoreCase(fieldName)).collect(Collectors.toList());
        if (ignoreCaseMatch.size() > 1) {
            throw new JdbcConnectorException("The SQL table has at least two columns that match the PDX field: " + fieldName);
        }
        if (ignoreCaseMatch.size() == 1) {
            return (String)ignoreCaseMatch.get(0);
        }
        return fieldName;
    }

    public String getFieldNameForColumn(String columnName, TypeRegistry typeRegistry) {
        String fieldName = null;
        if (this.getPdxName() == null) {
            fieldName = columnName.equals(columnName.toUpperCase()) ? columnName.toLowerCase() : columnName;
        } else {
            Set<PdxType> pdxTypes = this.getPdxTypesForClassName(typeRegistry);
            fieldName = this.findExactMatch(columnName, pdxTypes);
            if (fieldName == null) {
                fieldName = this.findCaseInsensitiveMatch(columnName, pdxTypes);
            }
        }
        assert (fieldName != null);
        return fieldName;
    }

    private Set<PdxType> getPdxTypesForClassName(TypeRegistry typeRegistry) {
        Set pdxTypes = typeRegistry.getPdxTypesForClassName(this.getPdxName());
        if (pdxTypes.isEmpty()) {
            throw new JdbcConnectorException("The class " + this.getPdxName() + " has not been pdx serialized.");
        }
        return pdxTypes;
    }

    private String findCaseInsensitiveMatch(String columnName, Set<PdxType> pdxTypes) {
        HashSet<String> matchingFieldNames = new HashSet<String>();
        for (PdxType pdxType : pdxTypes) {
            for (String existingFieldName : pdxType.getFieldNames()) {
                if (!existingFieldName.equalsIgnoreCase(columnName)) continue;
                matchingFieldNames.add(existingFieldName);
            }
        }
        if (matchingFieldNames.isEmpty()) {
            throw new JdbcConnectorException("The class " + this.getPdxName() + " does not have a field that matches the column " + columnName);
        }
        if (matchingFieldNames.size() > 1) {
            throw new JdbcConnectorException("Could not determine what pdx field to use for the column name " + columnName + " because the pdx fields " + matchingFieldNames + " all match it.");
        }
        return (String)matchingFieldNames.iterator().next();
    }

    private String findExactMatch(String columnName, Set<PdxType> pdxTypes) {
        for (PdxType pdxType : pdxTypes) {
            if (pdxType.getPdxField(columnName) == null) continue;
            return columnName;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionMapping that = (RegionMapping)o;
        if (this.regionName != null ? !this.regionName.equals(that.regionName) : that.regionName != null) {
            return false;
        }
        if (this.pdxName != null ? !this.pdxName.equals(that.pdxName) : that.pdxName != null) {
            return false;
        }
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        return !(this.connectionConfigName != null ? !this.connectionConfigName.equals(that.connectionConfigName) : that.connectionConfigName != null);
    }

    public int hashCode() {
        int result = this.regionName != null ? this.regionName.hashCode() : 0;
        result = 31 * result + (this.pdxName != null ? this.pdxName.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.connectionConfigName != null ? this.connectionConfigName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RegionMapping{regionName='" + this.regionName + '\'' + ", pdxName='" + this.pdxName + '\'' + ", tableName='" + this.tableName + '\'' + ", connectionConfigName='" + this.connectionConfigName + '\'' + '}';
    }

    public String getId() {
        return ELEMENT_ID;
    }
}

