/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.CreateMappingFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class CreateMappingCommand
extends SingleGfshCommand {
    static final String CREATE_MAPPING = "create jdbc-mapping";
    static final String CREATE_MAPPING__HELP = "(Experimental) Create a mapping for a region for use with a JDBC database connection.";
    static final String CREATE_MAPPING__REGION_NAME = "region";
    static final String CREATE_MAPPING__REGION_NAME__HELP = "Name of the region the mapping is being created for.";
    static final String CREATE_MAPPING__PDX_NAME = "pdx-name";
    static final String CREATE_MAPPING__PDX_NAME__HELP = "Name of pdx class for which values will be written to the database.";
    static final String CREATE_MAPPING__TABLE_NAME = "table";
    static final String CREATE_MAPPING__TABLE_NAME__HELP = "Name of database table for values to be written to.";
    static final String CREATE_MAPPING__CONNECTION_NAME = "connection";
    static final String CREATE_MAPPING__CONNECTION_NAME__HELP = "Name of JDBC connection to use.";

    @CliCommand(value={"create jdbc-mapping"}, help="(Experimental) Create a mapping for a region for use with a JDBC database connection.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel createMapping(@CliOption(key={"region"}, mandatory=true, help="Name of the region the mapping is being created for.") String regionName, @CliOption(key={"connection"}, mandatory=true, help="Name of JDBC connection to use.") String connectionName, @CliOption(key={"table"}, help="Name of database table for values to be written to.") String table, @CliOption(key={"pdx-name"}, help="Name of pdx class for which values will be written to the database.") String pdxName) {
        Set targetMembers = this.getMembers(null, null);
        RegionMapping mapping = new RegionMapping(regionName, pdxName, table, connectionName);
        List results = this.executeAndGetFunctionResult((Function)new CreateMappingFunction(), mapping, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
        result.setConfigObject((Object)mapping);
        return result;
    }

    public void updateClusterConfig(String group, CacheConfig cacheConfig, Object element) {
        RegionMapping newCacheElement = (RegionMapping)element;
        RegionMapping existingCacheElement = (RegionMapping)cacheConfig.findCustomRegionElement(newCacheElement.getRegionName(), newCacheElement.getId(), RegionMapping.class);
        if (existingCacheElement != null) {
            cacheConfig.getRegions().stream().filter(regionConfig -> regionConfig.getName().equals(newCacheElement.getRegionName())).forEach(regionConfig -> regionConfig.getCustomRegionElements().remove(existingCacheElement));
        }
        cacheConfig.getRegions().stream().filter(regionConfig -> regionConfig.getName().equals(newCacheElement.getRegionName())).forEach(regionConfig -> regionConfig.getCustomRegionElements().add(newCacheElement));
    }
}

