/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.TableMetaData;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;

public class TableMetaDataManager {
    private final ConcurrentMap<String, TableMetaDataView> tableToMetaDataMap = new ConcurrentHashMap<String, TableMetaDataView>();

    public TableMetaDataView getTableMetaDataView(Connection connection, String tableName) {
        return this.tableToMetaDataMap.computeIfAbsent(tableName, k -> this.computeTableMetaDataView(connection, (String)k));
    }

    private TableMetaDataView computeTableMetaDataView(Connection connection, String tableName) {
        TableMetaData result;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet tables = metaData.getTables(null, null, "%", null);){
                String realTableName = this.getTableNameFromMetaData(tableName, tables);
                String key = this.getPrimaryKeyColumnNameFromMetaData(realTableName, metaData);
                String quoteString = metaData.getIdentifierQuoteString();
                if (quoteString == null) {
                    quoteString = "";
                }
                result = new TableMetaData(realTableName, key, quoteString);
                this.getDataTypesFromMetaData(realTableName, metaData, result);
            }
        }
        catch (SQLException e) {
            throw JdbcConnectorException.createException(e);
        }
        return result;
    }

    private String getTableNameFromMetaData(String tableName, ResultSet tables) throws SQLException {
        String result = null;
        int inexactMatches = 0;
        while (tables.next()) {
            String name = tables.getString("TABLE_NAME");
            if (name.equals(tableName)) {
                return name;
            }
            if (!name.equalsIgnoreCase(tableName)) continue;
            ++inexactMatches;
            result = name;
        }
        if (inexactMatches > 1) {
            throw new JdbcConnectorException("Duplicate tables that match region name");
        }
        if (result == null) {
            throw new JdbcConnectorException("no table was found that matches " + tableName);
        }
        return result;
    }

    private String getPrimaryKeyColumnNameFromMetaData(String tableName, DatabaseMetaData metaData) throws SQLException {
        try (ResultSet primaryKeys = metaData.getPrimaryKeys(null, null, tableName);){
            if (!primaryKeys.next()) {
                throw new JdbcConnectorException("The table " + tableName + " does not have a primary key column.");
            }
            String key = primaryKeys.getString("COLUMN_NAME");
            if (primaryKeys.next()) {
                throw new JdbcConnectorException("The table " + tableName + " has more than one primary key column.");
            }
            String string = key;
            return string;
        }
    }

    private void getDataTypesFromMetaData(String tableName, DatabaseMetaData metaData, TableMetaData result) throws SQLException {
        try (ResultSet columnData = metaData.getColumns(null, null, tableName, "%");){
            while (columnData.next()) {
                String columnName = columnData.getString("COLUMN_NAME");
                int dataType = columnData.getInt("DATA_TYPE");
                result.addDataType(columnName, dataType);
            }
        }
    }
}

