/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.XSDRootElement;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

@Experimental
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"connection", "regionMapping"})
@XmlRootElement(name="connector-service", namespace="http://geode.apache.org/schema/jdbc")
@XSDRootElement(namespace="http://geode.apache.org/schema/jdbc", schemaLocation="http://geode.apache.org/schema/jdbc/jdbc-1.0.xsd")
public class ConnectorService
implements CacheElement {
    @XmlElement(namespace="http://geode.apache.org/schema/jdbc")
    protected List<Connection> connection;
    @XmlElement(name="region-mapping", namespace="http://geode.apache.org/schema/jdbc")
    protected List<RegionMapping> regionMapping;
    @XmlAttribute(name="name")
    protected String name;

    public List<Connection> getConnection() {
        if (this.connection == null) {
            this.connection = new ArrayList<Connection>();
        }
        return this.connection;
    }

    public List<RegionMapping> getRegionMapping() {
        if (this.regionMapping == null) {
            this.regionMapping = new ArrayList<RegionMapping>();
        }
        return this.regionMapping;
    }

    public String getName() {
        if (this.name == null) {
            return "connector-service";
        }
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getId() {
        return this.getName();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"fieldMapping"})
    public static class RegionMapping
    implements CacheElement {
        private static final String MAPPINGS_DELIMITER = ":";
        @XmlElement(name="field-mapping", namespace="http://geode.apache.org/schema/jdbc")
        protected List<FieldMapping> fieldMapping;
        @XmlTransient
        protected boolean fieldMappingModified = false;
        @XmlAttribute(name="connection-name")
        protected String connectionConfigName;
        @XmlAttribute(name="region")
        protected String regionName;
        @XmlAttribute(name="table")
        protected String tableName;
        @XmlAttribute(name="pdx-class")
        protected String pdxClassName;
        @XmlAttribute(name="primary-key-in-value")
        protected Boolean primaryKeyInValue;

        public RegionMapping() {
        }

        public RegionMapping(String regionName, String pdxClassName, String tableName, String connectionConfigName, Boolean primaryKeyInValue) {
            this.regionName = regionName;
            this.pdxClassName = pdxClassName;
            this.tableName = tableName;
            this.connectionConfigName = connectionConfigName;
            this.primaryKeyInValue = primaryKeyInValue;
        }

        public void setFieldMapping(String[] mappings) {
            if (mappings != null) {
                this.fieldMapping = Arrays.stream(mappings).filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(s -> {
                    String[] keyValuePair = s.split(MAPPINGS_DELIMITER);
                    this.validateParam(keyValuePair, (String)s);
                    return new FieldMapping(keyValuePair[0], keyValuePair[1]);
                }).collect(Collectors.toList());
                this.fieldMappingModified = true;
            }
        }

        private void validateParam(String[] paramKeyValue, String mapping) {
            if (paramKeyValue.length != 2 || paramKeyValue[0].isEmpty()) {
                throw new IllegalArgumentException("Field to column mapping '" + mapping + "' is not of the form 'Field" + MAPPINGS_DELIMITER + "Column'");
            }
        }

        public void setConnectionConfigName(String connectionConfigName) {
            this.connectionConfigName = connectionConfigName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setPdxClassName(String pdxClassName) {
            this.pdxClassName = pdxClassName;
        }

        public void setPrimaryKeyInValue(Boolean primaryKeyInValue) {
            this.primaryKeyInValue = primaryKeyInValue;
        }

        public boolean isFieldMappingModified() {
            return this.fieldMappingModified;
        }

        public List<FieldMapping> getFieldMapping() {
            if (this.fieldMapping == null) {
                this.fieldMapping = new ArrayList<FieldMapping>();
            }
            return this.fieldMapping;
        }

        public String getConnectionConfigName() {
            return this.connectionConfigName;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public String getPdxClassName() {
            return this.pdxClassName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Boolean getPrimaryKeyInValue() {
            return this.primaryKeyInValue;
        }

        public Boolean isPrimaryKeyInValue() {
            return this.primaryKeyInValue;
        }

        public String getRegionToTableName() {
            if (this.tableName == null) {
                return this.regionName;
            }
            return this.tableName;
        }

        public String getColumnNameForField(String fieldName, TableMetaDataView tableMetaDataView) {
            FieldMapping configured = this.getFieldMapping().stream().filter(m -> m.getFieldName().equals(fieldName)).findAny().orElse(null);
            if (configured != null) {
                return configured.getColumnName();
            }
            Set<String> columnNames = tableMetaDataView.getColumnNames();
            if (columnNames.contains(fieldName)) {
                return fieldName;
            }
            List ignoreCaseMatch = columnNames.stream().filter(c -> c.equalsIgnoreCase(fieldName)).collect(Collectors.toList());
            if (ignoreCaseMatch.size() > 1) {
                throw new JdbcConnectorException("The SQL table has at least two columns that match the PDX field: " + fieldName);
            }
            if (ignoreCaseMatch.size() == 1) {
                return (String)ignoreCaseMatch.get(0);
            }
            return fieldName;
        }

        public String getFieldNameForColumn(String columnName, TypeRegistry typeRegistry) {
            String fieldName = null;
            FieldMapping configured = this.getFieldMapping().stream().filter(m -> m.getColumnName().equals(columnName)).findAny().orElse(null);
            if (configured != null) {
                return configured.getFieldName();
            }
            if (this.getPdxClassName() == null) {
                fieldName = columnName.equals(columnName.toUpperCase()) ? columnName.toLowerCase() : columnName;
            } else {
                Set<PdxType> pdxTypes = this.getPdxTypesForClassName(typeRegistry);
                fieldName = this.findExactMatch(columnName, pdxTypes);
                if (fieldName == null) {
                    fieldName = this.findCaseInsensitiveMatch(columnName, pdxTypes);
                }
            }
            assert (fieldName != null);
            return fieldName;
        }

        private Set<PdxType> getPdxTypesForClassName(TypeRegistry typeRegistry) {
            Set pdxTypes = typeRegistry.getPdxTypesForClassName(this.getPdxClassName());
            if (pdxTypes.isEmpty()) {
                throw new JdbcConnectorException("The class " + this.getPdxClassName() + " has not been pdx serialized.");
            }
            return pdxTypes;
        }

        private String findCaseInsensitiveMatch(String columnName, Set<PdxType> pdxTypes) {
            HashSet<String> matchingFieldNames = new HashSet<String>();
            for (PdxType pdxType : pdxTypes) {
                for (String existingFieldName : pdxType.getFieldNames()) {
                    if (!existingFieldName.equalsIgnoreCase(columnName)) continue;
                    matchingFieldNames.add(existingFieldName);
                }
            }
            if (matchingFieldNames.isEmpty()) {
                throw new JdbcConnectorException("The class " + this.getPdxClassName() + " does not have a field that matches the column " + columnName);
            }
            if (matchingFieldNames.size() > 1) {
                throw new JdbcConnectorException("Could not determine what pdx field to use for the column name " + columnName + " because the pdx fields " + matchingFieldNames + " all match it.");
            }
            return (String)matchingFieldNames.iterator().next();
        }

        private String findExactMatch(String columnName, Set<PdxType> pdxTypes) {
            for (PdxType pdxType : pdxTypes) {
                if (pdxType.getPdxField(columnName) == null) continue;
                return columnName;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionMapping that = (RegionMapping)o;
            if (this.primaryKeyInValue != that.primaryKeyInValue) {
                return false;
            }
            if (this.regionName != null ? !this.regionName.equals(that.regionName) : that.regionName != null) {
                return false;
            }
            if (this.pdxClassName != null ? !this.pdxClassName.equals(that.pdxClassName) : that.pdxClassName != null) {
                return false;
            }
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
                return false;
            }
            if (this.connectionConfigName != null ? !this.connectionConfigName.equals(that.connectionConfigName) : that.connectionConfigName != null) {
                return false;
            }
            return !(this.fieldMapping != null ? !this.fieldMapping.equals(that.fieldMapping) : that.fieldMapping != null);
        }

        public int hashCode() {
            int result = this.regionName != null ? this.regionName.hashCode() : 0;
            result = 31 * result + (this.pdxClassName != null ? this.pdxClassName.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.connectionConfigName != null ? this.connectionConfigName.hashCode() : 0);
            result = 31 * result + (this.primaryKeyInValue != false ? 1 : 0);
            return result;
        }

        public String toString() {
            return "RegionMapping{regionName='" + this.regionName + '\'' + ", pdxClassName='" + this.pdxClassName + '\'' + ", tableName='" + this.tableName + '\'' + ", connectionConfigName='" + this.connectionConfigName + '\'' + ", primaryKeyInValue=" + this.primaryKeyInValue + '}';
        }

        public String getId() {
            return this.getRegionName();
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class FieldMapping
        implements Serializable {
            @XmlAttribute(name="field-name")
            protected String fieldName;
            @XmlAttribute(name="column-name")
            protected String columnName;

            public FieldMapping() {
            }

            public FieldMapping(String fieldName, String columnName) {
                this.fieldName = fieldName;
                this.columnName = columnName;
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public void setFieldName(String value) {
                this.fieldName = value;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public void setColumnName(String value) {
                this.columnName = value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                FieldMapping that = (FieldMapping)o;
                return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.columnName, that.columnName);
            }

            public int hashCode() {
                int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
                result = 31 * result + (this.columnName != null ? this.columnName.hashCode() : 0);
                return result;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Connection
    implements CacheElement {
        @XmlAttribute(name="name")
        protected String name;
        @XmlAttribute(name="url")
        protected String url;
        @XmlAttribute(name="user")
        protected String user;
        @XmlAttribute(name="password")
        protected String password;
        @XmlAttribute(name="parameters")
        protected String parameters;
        @XmlTransient
        protected Map<String, String> parameterMap = new HashMap<String, String>();

        public Connection() {
        }

        public Connection(String name, String url, String user, String password, String parameters) {
            this.name = name;
            this.url = url;
            this.user = user;
            this.password = password;
            this.setParameters(parameters);
        }

        public Connection(String name, String url, String user, String password, String[] parameters) {
            this.name = name;
            this.url = url;
            this.user = user;
            this.password = password;
            this.setParameters(parameters);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String value) {
            this.url = value;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String value) {
            this.user = value;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String value) {
            this.password = value;
        }

        public String getParameters() {
            return this.parameters;
        }

        public void setParameters(String value) {
            if (value == null) {
                return;
            }
            this.setParameters(value.split(","));
        }

        public void setParameters(String[] params) {
            if (params == null) {
                return;
            }
            Arrays.stream(params).forEach(s -> {
                if (!s.isEmpty()) {
                    String[] keyValuePair = s.split(":");
                    this.validateParam(keyValuePair, (String)s);
                    this.parameterMap.put(keyValuePair[0], keyValuePair[1]);
                }
            });
            this.parameters = Arrays.stream(params).collect(Collectors.joining(","));
        }

        public void setParameters(Map<String, String> parameterMap) {
            if (parameterMap == null) {
                return;
            }
            this.parameterMap = parameterMap;
            this.parameters = parameterMap.keySet().stream().map(k -> k + ":" + (String)parameterMap.get(k)).collect(Collectors.joining(","));
        }

        public Map<String, String> getParameterMap() {
            if (this.parameters != null && !this.parameters.isEmpty()) {
                String[] params = this.parameters.split(",");
                Arrays.stream(params).forEach(s -> {
                    String[] keyValuePair = s.split(":");
                    this.parameterMap.put(keyValuePair[0], keyValuePair[1]);
                });
            }
            return this.parameterMap;
        }

        private void validateParam(String[] paramKeyValue, String param) {
            if (paramKeyValue.length != 2 || paramKeyValue[0].isEmpty()) {
                throw new IllegalArgumentException("Parameter '" + param + "' is not of the form 'parameterName" + ":" + "value'");
            }
        }

        public Properties getConnectionProperties() {
            Properties properties = new Properties();
            if (this.parameterMap != null) {
                properties.putAll(this.parameterMap);
            }
            return properties;
        }

        public String getId() {
            return this.getName();
        }
    }
}

