/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.CreateConnectionFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class CreateConnectionCommand
extends SingleGfshCommand {
    private static final Logger logger = LogService.getLogger();
    static final String CREATE_CONNECTION = "create jdbc-connection";
    static final String CREATE_CONNECTION__HELP = "(Experimental) Create a connection for communicating with a database through jdbc.";
    static final String CREATE_CONNECTION__NAME = "name";
    static final String CREATE_CONNECTION__NAME__HELP = "Name of the connection to be created.";
    static final String CREATE_CONNECTION__URL = "url";
    static final String CREATE_CONNECTION__URL__HELP = "URL location for the database.";
    static final String CREATE_CONNECTION__USER = "user";
    static final String CREATE_CONNECTION__USER__HELP = "User name to use when connecting to database.";
    static final String CREATE_CONNECTION__PASSWORD = "password";
    static final String CREATE_CONNECTION__PASSWORD__HELP = "Password to use when connecting to database.";
    static final String CREATE_CONNECTION__PARAMS = "params";
    static final String CREATE_CONNECTION__PARAMS__HELP = "Additional parameters to use when connecting to the database formatted like \"key:value(,key:value)*\".";

    @CliCommand(value={"create jdbc-connection"}, help="(Experimental) Create a connection for communicating with a database through jdbc.")
    @CliMetaData(relatedTopic={"Geode"}, interceptor="org.apache.geode.connectors.jdbc.internal.cli.CreateConnectionCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel createConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the connection to be created.") String name, @CliOption(key={"url"}, mandatory=true, help="URL location for the database.") String url, @CliOption(key={"user"}, help="User name to use when connecting to database.") String user, @CliOption(key={"password"}, help="Password to use when connecting to database.") String password, @CliOption(key={"params"}, help="Additional parameters to use when connecting to the database formatted like \"key:value(,key:value)*\".") String[] params) {
        Set targetMembers = this.getMembers(null, null);
        ConnectorService.Connection connection = new ConnectorService.Connection(name, url, user, password, params);
        List results = this.executeAndGetFunctionResult((Function)new CreateConnectionFunction(), connection, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
        result.setConfigObject((Object)connection);
        return result;
    }

    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        ConnectorService.Connection connection = (ConnectorService.Connection)element;
        ConnectorService service = (ConnectorService)config.findCustomCacheElement("connector-service", ConnectorService.class);
        if (service == null) {
            service = new ConnectorService();
            config.getCustomCacheElements().add(service);
        }
        service.getConnection().add(connection);
    }

    @CliAvailabilityIndicator(value={"alter jdbc-connection", "alter jdbc-mapping", "create jdbc-connection", "create jdbc-mapping", "describe jdbc-connection", "describe jdbc-mapping", "destroy jdbc-connection", "destroy jdbc-mapping", "list jdbc-connections", "list jdbc-mappings"})
    public boolean available() {
        return this.isOnlineCommandAvailable();
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        public Result preExecution(GfshParseResult parseResult) {
            String user = parseResult.getParamValueAsString(CreateConnectionCommand.CREATE_CONNECTION__USER);
            String password = parseResult.getParamValueAsString(CreateConnectionCommand.CREATE_CONNECTION__PASSWORD);
            if (StringUtils.isNotBlank((String)password) && StringUtils.isBlank((String)user)) {
                return ResultBuilder.createUserErrorResult((String)"need to specify a user if a password is specified.");
            }
            return ResultBuilder.createInfoResult((String)"");
        }
    }
}

