/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingNotFoundException;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class AlterMappingFunction
extends CliFunction<ConnectorService.RegionMapping> {
    public CliFunctionResult executeFunction(FunctionContext<ConnectorService.RegionMapping> context) throws Exception {
        ConnectorService.RegionMapping mapping;
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        ConnectorService.RegionMapping existingMapping = service.getMappingForRegion((mapping = (ConnectorService.RegionMapping)context.getArguments()).getRegionName());
        if (existingMapping == null) {
            throw new RegionMappingNotFoundException("RegionMapping for region " + mapping.getRegionName() + " was not found");
        }
        ConnectorService.RegionMapping alteredMapping = this.alterRegionMapping(mapping, existingMapping);
        service.replaceRegionMapping(alteredMapping);
        return new CliFunctionResult(context.getMemberName(), (Object)alteredMapping, null);
    }

    ConnectorService.RegionMapping alterRegionMapping(ConnectorService.RegionMapping regionMapping, ConnectorService.RegionMapping existingMapping) {
        String connectionName = this.getValue(regionMapping.getConnectionConfigName(), existingMapping.getConnectionConfigName());
        String table = this.getValue(regionMapping.getTableName(), existingMapping.getTableName());
        String pdxClassName = this.getValue(regionMapping.getPdxClassName(), existingMapping.getPdxClassName());
        Boolean keyInValue = regionMapping.isPrimaryKeyInValue() == null ? existingMapping.isPrimaryKeyInValue() : regionMapping.isPrimaryKeyInValue();
        List<ConnectorService.RegionMapping.FieldMapping> fieldMappings = regionMapping.getFieldMapping();
        if (!regionMapping.isFieldMappingModified()) {
            fieldMappings = existingMapping.getFieldMapping();
        }
        ConnectorService.RegionMapping alteredMapping = new ConnectorService.RegionMapping(existingMapping.getRegionName(), pdxClassName, table, connectionName, keyInValue);
        alteredMapping.getFieldMapping().addAll(fieldMappings);
        return alteredMapping;
    }

    private String getValue(String newValue, String existingValue) {
        if (newValue == null) {
            return existingValue;
        }
        return newValue.isEmpty() ? null : newValue;
    }
}

