/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.HashMap;
import java.util.Set;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;

public class TableMetaData
implements TableMetaDataView {
    private final String tableName;
    private final String keyColumnName;
    private final HashMap<String, Integer> columnNameToTypeMap;
    private final String identifierQuoteString;

    public TableMetaData(String tableName, String keyColumnName, String quoteString) {
        this.tableName = tableName;
        this.keyColumnName = keyColumnName;
        this.columnNameToTypeMap = new HashMap();
        this.identifierQuoteString = quoteString;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    @Override
    public int getColumnDataType(String columnName) {
        Integer dataType = this.columnNameToTypeMap.get(columnName);
        if (dataType == null) {
            return 0;
        }
        return dataType;
    }

    @Override
    public Set<String> getColumnNames() {
        return this.columnNameToTypeMap.keySet();
    }

    public void addDataType(String columnName, int dataType) {
        this.columnNameToTypeMap.put(columnName, dataType);
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }
}

