/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.cli.JdbcCliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

@Experimental
public class DestroyMappingFunction
extends JdbcCliFunction<String, CliFunctionResult> {
    DestroyMappingFunction() {
    }

    @Override
    CliFunctionResult getFunctionResult(JdbcConnectorService service, FunctionContext<String> context) throws Exception {
        String regionName = (String)context.getArguments();
        boolean success = this.destroyRegionMapping(service, regionName);
        String member = this.getMember(context);
        return this.createResult(success, context, member, regionName);
    }

    boolean destroyRegionMapping(JdbcConnectorService service, String regionName) {
        RegionMapping mapping = service.getMappingForRegion(regionName);
        if (mapping != null) {
            service.destroyRegionMapping(regionName);
            return true;
        }
        return false;
    }

    private CliFunctionResult createResult(boolean success, FunctionContext<String> context, String member, String regionName) {
        CliFunctionResult result;
        if (success) {
            XmlEntity xmlEntity = this.createXmlEntity(context);
            result = this.createSuccessResult(member, regionName, xmlEntity);
        } else {
            result = this.createNotFoundResult(member, regionName);
        }
        return result;
    }

    private CliFunctionResult createSuccessResult(String member, String regionName, XmlEntity xmlEntity) {
        String message = "Destroyed region mapping for region " + regionName + " on " + member;
        return new CliFunctionResult(member, xmlEntity, message);
    }

    private CliFunctionResult createNotFoundResult(String member, String regionName) {
        String message = "Region mapping for region \"" + regionName + "\" not found";
        return new CliFunctionResult(member, false, message);
    }
}

