/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.JdbcCliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

@Experimental
public class DestroyConnectionFunction
extends JdbcCliFunction<String, CliFunctionResult> {
    DestroyConnectionFunction() {
    }

    @Override
    CliFunctionResult getFunctionResult(JdbcConnectorService service, FunctionContext<String> context) {
        String connectionName = (String)context.getArguments();
        boolean success = this.destroyConnectionConfig(service, connectionName);
        String member = this.getMember(context);
        return this.createResult(success, context, member, connectionName);
    }

    boolean destroyConnectionConfig(JdbcConnectorService service, String connectionName) {
        ConnectionConfiguration connectionConfig = service.getConnectionConfig(connectionName);
        if (connectionConfig != null) {
            service.destroyConnectionConfig(connectionName);
            return true;
        }
        return false;
    }

    private CliFunctionResult createResult(boolean success, FunctionContext<String> context, String member, String connectionName) {
        CliFunctionResult result;
        if (success) {
            XmlEntity xmlEntity = this.createXmlEntity(context);
            result = this.createSuccessResult(member, connectionName, xmlEntity);
        } else {
            result = this.createNotFoundResult(member, connectionName);
        }
        return result;
    }

    private CliFunctionResult createSuccessResult(String member, String connectionName, XmlEntity xmlEntity) {
        String message = "Destroyed JDBC connection \"" + connectionName + "\" on " + member;
        return new CliFunctionResult(member, xmlEntity, message);
    }

    private CliFunctionResult createNotFoundResult(String member, String connectionName) {
        String message = "Connection named \"" + connectionName + "\" not found";
        return new CliFunctionResult(member, false, message);
    }
}

