/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigBuilder;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.cli.AlterConnectionFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class AlterConnectionCommand
implements GfshCommand {
    static final String ALTER_JDBC_CONNECTION = "alter jdbc-connection";
    static final String ALTER_JDBC_CONNECTION__HELP = "(Experimental) Alter properties for an existing jdbc connection.";
    static final String ALTER_CONNECTION__NAME = "name";
    static final String ALTER_CONNECTION__NAME__HELP = "Name of the connection to be altered.";
    static final String ALTER_CONNECTION__URL = "url";
    static final String ALTER_CONNECTION__URL__HELP = "New URL location for the database.";
    static final String ALTER_CONNECTION__USER = "user";
    static final String ALTER_CONNECTION__USER__HELP = "New user name to use when connecting to database.";
    static final String ALTER_CONNECTION__PASSWORD = "password";
    static final String ALTER_CONNECTION__PASSWORD__HELP = "New password to use when connecting to database.";
    static final String ALTER_CONNECTION__PARAMS = "params";
    static final String ALTER_CONNECTION__PARAMS__HELP = "New additional parameters to use when connecting to the database. This replaces all previously existing parameters.";
    private static final String ERROR_PREFIX = "ERROR: ";

    @CliCommand(value={"alter jdbc-connection"}, help="(Experimental) Alter properties for an existing jdbc connection.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result alterConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the connection to be altered.") String name, @CliOption(key={"url"}, specifiedDefaultValue="", help="New URL location for the database.") String url, @CliOption(key={"user"}, specifiedDefaultValue="", help="New user name to use when connecting to database.") String user, @CliOption(key={"password"}, specifiedDefaultValue="", help="New password to use when connecting to database.") String password, @CliOption(key={"params"}, specifiedDefaultValue="", help="New additional parameters to use when connecting to the database. This replaces all previously existing parameters.") String[] params) {
        Set targetMembers = this.getMembers(null, null);
        ConnectionConfiguration configuration = this.getArguments(name, url, user, password, params);
        ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector = this.execute(new AlterConnectionFunction(), configuration, targetMembers);
        TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
        XmlEntity xmlEntity = this.fillTabularResultData(resultCollector, tabularResultData);
        tabularResultData.setHeader("(Experimental) ");
        CommandResult result = ResultBuilder.buildResult((ResultData)tabularResultData);
        this.updateClusterConfiguration((Result)result, xmlEntity);
        return result;
    }

    ResultCollector<CliFunctionResult, List<CliFunctionResult>> execute(AlterConnectionFunction function, ConnectionConfiguration configuration, Set<DistributedMember> targetMembers) {
        return this.executeFunction((Function)function, configuration, targetMembers);
    }

    private ConnectionConfiguration getArguments(String name, String url, String user, String password, String[] params) {
        ConnectionConfigBuilder builder = new ConnectionConfigBuilder().withName(name).withUrl(url).withUser(user).withPassword(password).withParameters(params);
        return builder.build();
    }

    private XmlEntity fillTabularResultData(ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector, TabularResultData tabularResultData) {
        XmlEntity xmlEntity = null;
        for (CliFunctionResult oneResult : (List)resultCollector.getResult()) {
            if (oneResult.isSuccessful()) {
                xmlEntity = this.addSuccessToResults(tabularResultData, oneResult);
                continue;
            }
            this.addErrorToResults(tabularResultData, oneResult);
        }
        return xmlEntity;
    }

    private XmlEntity addSuccessToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)oneResult.getMessage());
        return oneResult.getXmlEntity();
    }

    private void addErrorToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)(ERROR_PREFIX + oneResult.getMessage()));
        tabularResultData.setStatus(Result.Status.ERROR);
    }

    private void updateClusterConfiguration(Result result, XmlEntity xmlEntity) {
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity(xmlEntity, null));
        }
    }
}

