/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.List;
import org.apache.geode.connectors.jdbc.internal.ColumnValue;

class SqlStatementFactory {
    SqlStatementFactory() {
    }

    String createSelectQueryString(String tableName, List<ColumnValue> columnList) {
        assert (columnList.size() == 1);
        ColumnValue keyCV = columnList.get(0);
        assert (keyCV.isKey());
        return "SELECT * FROM " + tableName + " WHERE " + keyCV.getColumnName() + " = ?";
    }

    String createDestroySqlString(String tableName, List<ColumnValue> columnList) {
        assert (columnList.size() == 1);
        ColumnValue keyCV = columnList.get(0);
        assert (keyCV.isKey());
        return "DELETE FROM " + tableName + " WHERE " + keyCV.getColumnName() + " = ?";
    }

    String createUpdateSqlString(String tableName, List<ColumnValue> columnList) {
        StringBuilder query = new StringBuilder("UPDATE " + tableName + " SET ");
        int idx = 0;
        for (ColumnValue column : columnList) {
            if (column.isKey()) continue;
            if (++idx > 1) {
                query.append(", ");
            }
            query.append(column.getColumnName());
            query.append(" = ?");
        }
        for (ColumnValue column : columnList) {
            if (!column.isKey()) continue;
            query.append(" WHERE ");
            query.append(column.getColumnName());
            query.append(" = ?");
            break;
        }
        return query.toString();
    }

    String createInsertSqlString(String tableName, List<ColumnValue> columnList) {
        StringBuilder columnNames = new StringBuilder("INSERT INTO " + tableName + " (");
        StringBuilder columnValues = new StringBuilder(" VALUES (");
        int columnCount = columnList.size();
        int idx = 0;
        for (ColumnValue column : columnList) {
            columnNames.append(column.getColumnName());
            columnValues.append('?');
            if (++idx == columnCount) continue;
            columnNames.append(", ");
            columnValues.append(",");
        }
        columnNames.append(")");
        columnValues.append(")");
        return columnNames.append((CharSequence)columnValues).toString();
    }
}

