/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.ColumnValue;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.DataSourceManager;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.SqlStatementFactory;
import org.apache.geode.connectors.jdbc.internal.TableKeyColumnManager;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;

@Experimental
public class SqlHandler {
    private final JdbcConnectorService configService;
    private final DataSourceManager manager;
    private final TableKeyColumnManager tableKeyColumnManager;

    public SqlHandler(DataSourceManager manager, JdbcConnectorService configService) {
        this(manager, new TableKeyColumnManager(), configService);
    }

    SqlHandler(DataSourceManager manager, TableKeyColumnManager tableKeyColumnManager, JdbcConnectorService configService) {
        this.manager = manager;
        this.tableKeyColumnManager = tableKeyColumnManager;
        this.configService = configService;
    }

    public void close() {
        this.manager.close();
    }

    Connection getConnection(ConnectionConfiguration config) throws SQLException {
        return this.manager.getDataSource(config).getConnection();
    }

    public <K, V> PdxInstance read(Region<K, V> region, K key) throws SQLException {
        PdxInstance result;
        if (key == null) {
            throw new IllegalArgumentException("Key for query cannot be null");
        }
        RegionMapping regionMapping = this.getMappingForRegion(region.getName());
        ConnectionConfiguration connectionConfig = this.getConnectionConfig(regionMapping.getConnectionConfigName());
        String tableName = regionMapping.getRegionToTableName();
        try (Connection connection = this.getConnection(connectionConfig);){
            List<ColumnValue> columnList = this.getColumnToValueList(connection, regionMapping, key, null, Operation.GET);
            try (PreparedStatement statement = this.getPreparedStatement(connection, columnList, tableName, Operation.GET);){
                PdxInstanceFactory factory = this.getPdxInstanceFactory(region, regionMapping);
                String keyColumnName = this.getKeyColumnName(connection, tableName);
                result = this.executeReadStatement(statement, columnList, factory, regionMapping, keyColumnName);
            }
        }
        return result;
    }

    private RegionMapping getMappingForRegion(String regionName) {
        RegionMapping regionMapping = this.configService.getMappingForRegion(regionName);
        if (regionMapping == null) {
            throw new IllegalStateException("JDBC mapping for region " + regionName + " not found. Create the mapping with the gfsh command 'create jdbc-mapping'.");
        }
        return regionMapping;
    }

    private ConnectionConfiguration getConnectionConfig(String connectionConfigName) {
        ConnectionConfiguration connectionConfig = this.configService.getConnectionConfig(connectionConfigName);
        if (connectionConfig == null) {
            throw new IllegalStateException("JDBC connection with name " + connectionConfigName + " not found. Create the connection with the gfsh command 'create jdbc-connection'");
        }
        return connectionConfig;
    }

    private String getKeyColumnName(Connection connection, String tableName) {
        return this.tableKeyColumnManager.getKeyColumnName(connection, tableName);
    }

    private <K, V> PdxInstanceFactory getPdxInstanceFactory(Region<K, V> region, RegionMapping regionMapping) {
        InternalCache cache = (InternalCache)region.getRegionService();
        String valueClassName = regionMapping.getPdxClassName();
        PdxInstanceFactory factory = valueClassName != null ? cache.createPdxInstanceFactory(valueClassName) : cache.createPdxInstanceFactory("no class", false);
        return factory;
    }

    PdxInstance executeReadStatement(PreparedStatement statement, List<ColumnValue> columnList, PdxInstanceFactory factory, RegionMapping regionMapping, String keyColumnName) throws SQLException {
        PdxInstance pdxInstance = null;
        this.setValuesInStatement(statement, columnList);
        try (ResultSet resultSet = statement.executeQuery();){
            if (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int ColumnsNumber = metaData.getColumnCount();
                for (int i = 1; i <= ColumnsNumber; ++i) {
                    Object columnValue = resultSet.getObject(i);
                    String columnName = metaData.getColumnName(i);
                    String fieldName = this.mapColumnNameToFieldName(columnName, regionMapping);
                    if (!regionMapping.isPrimaryKeyInValue().booleanValue() && keyColumnName.equalsIgnoreCase(columnName)) continue;
                    factory.writeField(fieldName, columnValue, Object.class);
                }
                if (resultSet.next()) {
                    throw new JdbcConnectorException("Multiple rows returned for query: " + resultSet.getStatement().toString());
                }
                pdxInstance = factory.create();
            }
        }
        return pdxInstance;
    }

    private void setValuesInStatement(PreparedStatement statement, List<ColumnValue> columnList) throws SQLException {
        int index = 0;
        for (ColumnValue columnValue : columnList) {
            statement.setObject(++index, columnValue.getValue());
        }
    }

    private String mapColumnNameToFieldName(String columnName, RegionMapping regionMapping) {
        return regionMapping.getFieldNameForColumn(columnName);
    }

    public <K, V> void write(Region<K, V> region, Operation operation, K key, PdxInstance value) throws SQLException {
        if (value == null && operation != Operation.DESTROY) {
            throw new IllegalArgumentException("PdxInstance cannot be null for non-destroy operations");
        }
        RegionMapping regionMapping = this.getMappingForRegion(region.getName());
        ConnectionConfiguration connectionConfig = this.getConnectionConfig(regionMapping.getConnectionConfigName());
        String tableName = regionMapping.getRegionToTableName();
        try (Connection connection = this.getConnection(connectionConfig);){
            int updateCount;
            List<ColumnValue> columnList;
            block45: {
                columnList = this.getColumnToValueList(connection, regionMapping, key, value, operation);
                updateCount = 0;
                try (PreparedStatement statement = this.getPreparedStatement(connection, columnList, tableName, operation);){
                    updateCount = this.executeWriteStatement(statement, columnList);
                }
                catch (SQLException e) {
                    if (!operation.isDestroy()) break block45;
                    throw e;
                }
            }
            if (operation.isDestroy()) {
                return;
            }
            if (updateCount <= 0) {
                Operation upsertOp = this.getOppositeOperation(operation);
                try (PreparedStatement upsertStatement = this.getPreparedStatement(connection, columnList, tableName, upsertOp);){
                    updateCount = this.executeWriteStatement(upsertStatement, columnList);
                }
            }
            if (updateCount != 1) {
                throw new IllegalStateException("Unexpected updateCount " + updateCount);
            }
        }
    }

    private Operation getOppositeOperation(Operation operation) {
        return operation.isUpdate() ? Operation.CREATE : Operation.UPDATE;
    }

    private int executeWriteStatement(PreparedStatement statement, List<ColumnValue> columnList) throws SQLException {
        this.setValuesInStatement(statement, columnList);
        return statement.executeUpdate();
    }

    private PreparedStatement getPreparedStatement(Connection connection, List<ColumnValue> columnList, String tableName, Operation operation) throws SQLException {
        String sqlStr = this.getSqlString(tableName, columnList, operation);
        return connection.prepareStatement(sqlStr);
    }

    private String getSqlString(String tableName, List<ColumnValue> columnList, Operation operation) {
        SqlStatementFactory statementFactory = new SqlStatementFactory();
        if (operation.isCreate()) {
            return statementFactory.createInsertSqlString(tableName, columnList);
        }
        if (operation.isUpdate()) {
            return statementFactory.createUpdateSqlString(tableName, columnList);
        }
        if (operation.isDestroy()) {
            return statementFactory.createDestroySqlString(tableName, columnList);
        }
        if (operation.isGet()) {
            return statementFactory.createSelectQueryString(tableName, columnList);
        }
        throw new IllegalArgumentException("unsupported operation " + operation);
    }

    <K> List<ColumnValue> getColumnToValueList(Connection connection, RegionMapping regionMapping, K key, PdxInstance value, Operation operation) {
        String tableName = regionMapping.getRegionToTableName();
        String keyColumnName = this.getKeyColumnName(connection, tableName);
        ColumnValue keyColumnValue = new ColumnValue(true, keyColumnName, key);
        if (operation.isDestroy() || operation.isGet()) {
            return Collections.singletonList(keyColumnValue);
        }
        List<ColumnValue> result = this.createColumnValueList(regionMapping, value, keyColumnName);
        result.add(keyColumnValue);
        return result;
    }

    private List<ColumnValue> createColumnValueList(RegionMapping regionMapping, PdxInstance value, String keyColumnName) {
        ArrayList<ColumnValue> result = new ArrayList<ColumnValue>();
        for (String fieldName : value.getFieldNames()) {
            String columnName = regionMapping.getColumnNameForField(fieldName);
            if (columnName.equalsIgnoreCase(keyColumnName)) continue;
            ColumnValue columnValue = new ColumnValue(false, columnName, value.getField(fieldName));
            result.add(columnValue);
        }
        return result;
    }
}

