/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.CopyHelper;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.asyncqueue.AsyncEvent;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.connectors.jdbc.internal.AbstractJdbcCallback;
import org.apache.geode.connectors.jdbc.internal.SqlHandler;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;

@Experimental
public class JdbcAsyncWriter
extends AbstractJdbcCallback
implements AsyncEventListener {
    private static final Logger logger = LogService.getLogger();
    private AtomicLong totalEvents = new AtomicLong();
    private AtomicLong successfulEvents = new AtomicLong();
    private AtomicLong failedEvents = new AtomicLong();

    public JdbcAsyncWriter() {
    }

    JdbcAsyncWriter(SqlHandler sqlHandler) {
        super(sqlHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processEvents(List<AsyncEvent> events) {
        this.changeTotalEvents(events.size());
        if (!events.isEmpty()) {
            this.checkInitialized((InternalCache)events.get(0).getRegion().getRegionService());
        }
        DefaultQuery.setPdxReadSerialized((boolean)true);
        try {
            for (AsyncEvent event : events) {
                try {
                    this.getSqlHandler().write(event.getRegion(), event.getOperation(), event.getKey(), this.getPdxInstance(event));
                    this.changeSuccessfulEvents(1L);
                }
                catch (RuntimeException | SQLException ex) {
                    this.changeFailedEvents(1L);
                    logger.error("Exception processing event {}", (Object)event, (Object)ex);
                }
            }
        }
        finally {
            DefaultQuery.setPdxReadSerialized((boolean)false);
        }
        return true;
    }

    long getTotalEvents() {
        return this.totalEvents.get();
    }

    long getSuccessfulEvents() {
        return this.successfulEvents.get();
    }

    long getFailedEvents() {
        return this.failedEvents.get();
    }

    private void changeSuccessfulEvents(long delta) {
        this.successfulEvents.addAndGet(delta);
    }

    private void changeFailedEvents(long delta) {
        this.failedEvents.addAndGet(delta);
    }

    private void changeTotalEvents(long delta) {
        this.totalEvents.addAndGet(delta);
    }

    private PdxInstance getPdxInstance(AsyncEvent event) {
        Object value = event.getDeserializedValue();
        if (!(value instanceof PdxInstance)) {
            value = CopyHelper.copy((Object)value);
        }
        return (PdxInstance)value;
    }
}

