/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;

@Experimental
public class RegionMappingBuilder {
    private static final String MAPPINGS_DELIMITER = ":";
    private String regionName;
    private String pdxClassName;
    private String tableName;
    private String connectionConfigName;
    private Boolean primaryKeyInValue;
    private Map<String, String> fieldToColumnMap = new HashMap<String, String>();

    public RegionMappingBuilder withRegionName(String regionName) {
        this.regionName = regionName;
        return this;
    }

    public RegionMappingBuilder withPdxClassName(String pdxClassName) {
        this.pdxClassName = pdxClassName;
        return this;
    }

    public RegionMappingBuilder withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public RegionMappingBuilder withConnectionConfigName(String connectionConfigName) {
        this.connectionConfigName = connectionConfigName;
        return this;
    }

    public RegionMappingBuilder withPrimaryKeyInValue(String v) {
        if (v != null) {
            this.withPrimaryKeyInValue(Boolean.parseBoolean(v));
        }
        return this;
    }

    public RegionMappingBuilder withPrimaryKeyInValue(Boolean v) {
        this.primaryKeyInValue = v;
        return this;
    }

    public RegionMappingBuilder withFieldToColumnMapping(String fieldName, String columnMapping) {
        this.fieldToColumnMap.put(fieldName, columnMapping);
        return this;
    }

    public RegionMappingBuilder withFieldToColumnMappings(String[] mappings) {
        if (mappings == null) {
            this.fieldToColumnMap = null;
        } else {
            for (String mapping : mappings) {
                if (mapping.isEmpty()) continue;
                String[] keyValuePair = mapping.split(MAPPINGS_DELIMITER);
                this.validateParam(keyValuePair, mapping);
                this.fieldToColumnMap.put(keyValuePair[0], keyValuePair[1]);
            }
        }
        return this;
    }

    private void validateParam(String[] paramKeyValue, String mapping) {
        if (paramKeyValue.length != 2 || paramKeyValue[0].isEmpty()) {
            throw new IllegalArgumentException("Field to column mapping '" + mapping + "' is not of the form 'Field" + MAPPINGS_DELIMITER + "Column'");
        }
    }

    public RegionMapping build() {
        return new RegionMapping(this.regionName, this.pdxClassName, this.tableName, this.connectionConfigName, this.primaryKeyInValue, this.fieldToColumnMap);
    }
}

