/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.geode.annotations.Experimental;

@Experimental
public class RegionMapping
implements Serializable {
    private final String regionName;
    private final String pdxClassName;
    private final String tableName;
    private final String connectionConfigName;
    private final Boolean primaryKeyInValue;
    private final Map<String, String> fieldToColumnMap;

    public RegionMapping(String regionName, String pdxClassName, String tableName, String connectionConfigName, Boolean primaryKeyInValue, Map<String, String> fieldToColumnMap) {
        this.regionName = regionName;
        this.pdxClassName = pdxClassName;
        this.tableName = tableName;
        this.connectionConfigName = connectionConfigName;
        this.primaryKeyInValue = primaryKeyInValue;
        this.fieldToColumnMap = fieldToColumnMap == null ? null : Collections.unmodifiableMap(fieldToColumnMap);
    }

    public String getConnectionConfigName() {
        return this.connectionConfigName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getPdxClassName() {
        return this.pdxClassName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Boolean isPrimaryKeyInValue() {
        return this.primaryKeyInValue;
    }

    public String getRegionToTableName() {
        if (this.tableName == null) {
            return this.regionName;
        }
        return this.tableName;
    }

    public String getColumnNameForField(String fieldName) {
        String columnName = null;
        if (this.fieldToColumnMap != null) {
            columnName = this.fieldToColumnMap.get(fieldName);
        }
        return columnName != null ? columnName : fieldName;
    }

    public Map<String, String> getFieldToColumnMap() {
        return this.fieldToColumnMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionMapping that = (RegionMapping)o;
        if (this.primaryKeyInValue != that.primaryKeyInValue) {
            return false;
        }
        if (this.regionName != null ? !this.regionName.equals(that.regionName) : that.regionName != null) {
            return false;
        }
        if (this.pdxClassName != null ? !this.pdxClassName.equals(that.pdxClassName) : that.pdxClassName != null) {
            return false;
        }
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        if (this.connectionConfigName != null ? !this.connectionConfigName.equals(that.connectionConfigName) : that.connectionConfigName != null) {
            return false;
        }
        return this.fieldToColumnMap != null ? this.fieldToColumnMap.equals(that.fieldToColumnMap) : that.fieldToColumnMap == null;
    }

    public int hashCode() {
        int result = this.regionName != null ? this.regionName.hashCode() : 0;
        result = 31 * result + (this.pdxClassName != null ? this.pdxClassName.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.connectionConfigName != null ? this.connectionConfigName.hashCode() : 0);
        result = 31 * result + (this.primaryKeyInValue != false ? 1 : 0);
        result = 31 * result + (this.fieldToColumnMap != null ? this.fieldToColumnMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RegionMapping{regionName='" + this.regionName + '\'' + ", pdxClassName='" + this.pdxClassName + '\'' + ", tableName='" + this.tableName + '\'' + ", connectionConfigName='" + this.connectionConfigName + '\'' + ", primaryKeyInValue=" + this.primaryKeyInValue + ", fieldToColumnMap=" + this.fieldToColumnMap + '}';
    }
}

