/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.concurrency.jpf;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.test.concurrency.ParallelExecutor;

class ParallelExecutorImpl
implements ParallelExecutor {
    List<ThreadFuture<?>> futures = new ArrayList();

    ParallelExecutorImpl() {
    }

    @Override
    public <T> Future<T> inParallel(Callable<T> callable) {
        ThreadFuture<T> future = ParallelExecutorImpl.newThread(callable);
        this.futures.add(future);
        return future;
    }

    @Override
    public void execute() throws ExecutionException, InterruptedException {
        for (ThreadFuture<?> future : this.futures) {
            future.start();
        }
        for (ThreadFuture<?> future : this.futures) {
            future.get();
        }
    }

    private static <T> ThreadFuture<T> newThread(Callable<T> callable) {
        ThreadFuture<T> future = new ThreadFuture<T>(callable);
        Thread thread = new Thread(future);
        future.setThread(thread);
        return future;
    }

    private static class ThreadFuture<T>
    extends FutureTask<T> {
        private Thread thread;

        public ThreadFuture(Callable<T> callable) {
            super(callable);
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.thread.join();
            return (T)super.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.thread.join(unit.toMillis(timeout));
            return (T)super.get(0L, TimeUnit.MILLISECONDS);
        }

        public void start() {
            this.thread.start();
        }
    }
}

