/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.concurrency.jpf;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.geode.test.concurrency.ParallelExecutor;
import org.apache.geode.test.concurrency.Runner;
import org.apache.geode.test.concurrency.jpf.JpfRunnerConfig;
import org.apache.geode.test.concurrency.jpf.ParallelExecutorImpl;

public class JpfRunner
implements Runner {
    @Override
    public List<Throwable> runTestMethod(Method child) {
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        String[] userConfig = this.getUserConfiguration(child);
        Config config = JPF.createConfig((String[])userConfig);
        config.setTarget(TestMain.class.getName());
        config.setTargetArgs(new String[]{child.getDeclaringClass().getName(), child.getName()});
        config.setProperty("report.probe_interval", "5");
        config.setProperty("peer_packages+", "org.apache.geode.test.concurrency.jpf.peers");
        config.setProperty("classpath", this.getClasspath());
        config.setProperty("vm.shared.skip_static_finals", "true");
        config.setProperty("vm.shared.skip_constructed_finals", "true");
        JPF jpf = new JPF(config);
        try {
            jpf.run();
        }
        catch (Throwable e) {
            failures.add((Throwable)((Object)new AssertionError("JPF had an internal error", e)));
        }
        jpf.getSearchErrors().stream().forEach(error -> failures.add((Throwable)((Object)new AssertionError((Object)("JPF found test failures: " + error.getDescription())))));
        return failures;
    }

    private String[] getUserConfiguration(Method child) {
        JpfRunnerConfig annotation = child.getDeclaringClass().getAnnotation(JpfRunnerConfig.class);
        if (annotation != null) {
            return annotation.value();
        }
        return new String[0];
    }

    private String getClasspath() {
        Collection<String> classpath = this.pathElements(System.getProperty("java.class.path"));
        Collection<String> bootClasspath = this.pathElements(System.getProperty("sun.boot.class.path"));
        classpath.removeAll(bootClasspath);
        return String.join((CharSequence)File.pathSeparator, classpath);
    }

    private Collection<String> pathElements(String path) {
        return new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
    }

    public static class TestMain {
        public static void main(String[] args) throws Exception {
            String clazzName = args[0];
            String methodName = args[1];
            Class<?> clazz = Class.forName(clazzName);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(methodName, ParallelExecutor.class);
            ParallelExecutorImpl parallelExecutor = new ParallelExecutorImpl();
            method.invoke(instance, parallelExecutor);
        }
    }
}

