/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.concurrency;

import java.util.Arrays;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.geode.test.concurrency.ParallelExecutor;
import org.apache.geode.test.concurrency.Runner;
import org.apache.geode.test.concurrency.annotation.ConcurrentTestConfig;
import org.apache.geode.test.concurrency.loop.LoopRunner;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class ConcurrentTestRunner
extends ParentRunner<FrameworkMethod> {
    private final Runner runner;

    public ConcurrentTestRunner(Class testClass) throws InitializationError {
        super(testClass);
        ConcurrentTestConfig configuration = (ConcurrentTestConfig)this.getTestClass().getAnnotation(ConcurrentTestConfig.class);
        if (configuration == null) {
            this.runner = new LoopRunner();
            return;
        }
        try {
            this.runner = configuration.runner().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected List<FrameworkMethod> getChildren() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.validateTestMethods(this.getChildren(), errors);
    }

    private void validateTestMethods(List<FrameworkMethod> methods, List<Throwable> errors) {
        for (FrameworkMethod method : methods) {
            if (Arrays.equals(method.getMethod().getParameterTypes(), new Class[]{ParallelExecutor.class})) continue;
            errors.add((Throwable)new AssertionFailedError("Incorrect signature on method: " + method + ". For a concurrent test, all test methods should take a ParallelExector parameter."));
        }
    }

    protected Description describeChild(FrameworkMethod child) {
        return Description.createTestDescription((Class)child.getDeclaringClass(), (String)child.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod child, RunNotifier notifier) {
        notifier.fireTestStarted(this.describeChild(child));
        try {
            List<Throwable> failures = this.runner.runTestMethod(child.getMethod());
            failures.stream().forEach(failure -> notifier.fireTestFailure(new Failure(this.describeChild(child), failure)));
        }
        finally {
            notifier.fireTestFinished(this.describeChild(child));
        }
    }
}

