/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.ResourceInformationReflector;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorProcessSpecContainerResourcePriorityAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorProcessSpecContainerResourcePriorityAdapter.class);
    private final Map<TaskExecutorProcessSpec, PriorityAndResource> taskExecutorProcessSpecToPriorityAndResource;
    private final Map<Priority, TaskExecutorProcessSpec> priorityToTaskExecutorProcessSpec;
    private final Resource maxContainerResource;
    private final Map<String, Long> maxExternalResources;
    private final Map<String, String> externalResourceConfigKeys;
    private int nextPriority = 1;

    TaskExecutorProcessSpecContainerResourcePriorityAdapter(Resource maxContainerResource, Map<String, String> externalResourceConfigKeys) {
        this.maxContainerResource = (Resource)Preconditions.checkNotNull((Object)maxContainerResource);
        this.externalResourceConfigKeys = (Map)Preconditions.checkNotNull(externalResourceConfigKeys);
        this.taskExecutorProcessSpecToPriorityAndResource = new HashMap<TaskExecutorProcessSpec, PriorityAndResource>();
        this.priorityToTaskExecutorProcessSpec = new HashMap<Priority, TaskExecutorProcessSpec>();
        this.maxExternalResources = ResourceInformationReflector.INSTANCE.getExternalResources(maxContainerResource);
    }

    Optional<PriorityAndResource> getPriorityAndResource(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        this.tryAdaptAndAddTaskExecutorResourceSpecIfNotExist(taskExecutorProcessSpec);
        return Optional.ofNullable(this.taskExecutorProcessSpecToPriorityAndResource.get(taskExecutorProcessSpec));
    }

    Optional<TaskExecutorProcessSpecAndResource> getTaskExecutorProcessSpecAndResource(Priority priority) {
        TaskExecutorProcessSpec taskExecutorProcessSpec = this.priorityToTaskExecutorProcessSpec.get(priority);
        if (taskExecutorProcessSpec == null) {
            return Optional.empty();
        }
        PriorityAndResource priorityAndResource = this.taskExecutorProcessSpecToPriorityAndResource.get(taskExecutorProcessSpec);
        Preconditions.checkState((priorityAndResource != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)priority.equals((Object)priorityAndResource.getPriority()));
        return Optional.of(new TaskExecutorProcessSpecAndResource(taskExecutorProcessSpec, priorityAndResource.getResource()));
    }

    private void validateExternalResourceConfig(String configKey, long value) {
        Preconditions.checkState((boolean)this.maxExternalResources.containsKey(configKey), (String)"External resource %s is not supported by the Yarn cluster.", (Object[])new Object[]{configKey});
        Preconditions.checkState((value <= this.maxExternalResources.get(configKey) ? 1 : 0) != 0, (String)"Configured value for external resource %s (%s) exceeds the max limitation of the Yarn cluster (%s).", (Object[])new Object[]{configKey, value, this.maxExternalResources.get(configKey)});
    }

    private void tryAdaptAndAddTaskExecutorResourceSpecIfNotExist(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        if (!this.taskExecutorProcessSpecToPriorityAndResource.containsKey(taskExecutorProcessSpec)) {
            this.tryAdaptResource(taskExecutorProcessSpec).ifPresent(resource -> {
                Priority priority = Priority.newInstance((int)this.nextPriority++);
                this.taskExecutorProcessSpecToPriorityAndResource.put(taskExecutorProcessSpec, new PriorityAndResource(priority, (Resource)resource));
                this.priorityToTaskExecutorProcessSpec.put(priority, taskExecutorProcessSpec);
            });
        }
    }

    private Optional<Resource> tryAdaptResource(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        Resource resource = Resource.newInstance((int)taskExecutorProcessSpec.getTotalProcessMemorySize().getMebiBytes(), (int)taskExecutorProcessSpec.getCpuCores().getValue().intValue());
        if (resource.getMemorySize() > this.maxContainerResource.getMemorySize() || resource.getVirtualCores() > this.maxContainerResource.getVirtualCores()) {
            LOG.warn("Requested container resource ({}) exceeds the max limitation of the Yarn cluster ({}). Will not allocate resource.", (Object)resource, (Object)this.maxContainerResource);
            return Optional.empty();
        }
        taskExecutorProcessSpec.getExtendedResources().forEach((resourceName, externalResource) -> {
            String configKey = this.externalResourceConfigKeys.get(resourceName);
            long value = externalResource.getValue().longValue();
            if (configKey != null) {
                this.validateExternalResourceConfig(configKey, value);
                ResourceInformationReflector.INSTANCE.setResourceInformation(resource, configKey, value);
            }
        });
        return Optional.of(resource);
    }

    class TaskExecutorProcessSpecAndResource {
        private final TaskExecutorProcessSpec taskExecutorProcessSpec;
        private final Resource resource;

        private TaskExecutorProcessSpecAndResource(TaskExecutorProcessSpec taskExecutorProcessSpec, Resource resource) {
            this.taskExecutorProcessSpec = (TaskExecutorProcessSpec)Preconditions.checkNotNull((Object)taskExecutorProcessSpec);
            this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
        }

        TaskExecutorProcessSpec getTaskExecutorProcessSpec() {
            return this.taskExecutorProcessSpec;
        }

        Resource getResource() {
            return this.resource;
        }
    }

    class PriorityAndResource {
        private final Priority priority;
        private final Resource resource;

        private PriorityAndResource(Priority priority, Resource resource) {
            this.priority = (Priority)Preconditions.checkNotNull((Object)priority);
            this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
        }

        Priority getPriority() {
            return this.priority;
        }

        Resource getResource() {
            return this.resource;
        }
    }
}

